/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules;

import com.ez.codingrules.Rule;
import com.ez.codingrules.RuleInput;
import com.ez.codingrules.RuleParameter;
import com.ez.codingrules.internal.Activator;
import com.ez.internal.utils.PathMappingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RulesManager.class);
    public static final String ROOT_ID = "root";
    private Rule root = null;
    public static final String INCLUDES_TOTAL = "includes";
    public static final String GROUPS_TOTAL = "groups";
    public static final String PARAMETERS_TOTAL = "parameters";
    public static final String RULES_TOTAL = "rules";
    public static final String RULE_ID = ".rule.id";
    public static final String RULE_NAME = ".rule.name";
    public static final String RULE_SOURCE_BASED = ".rule.sourceBased";
    public static final String RULE_WEIGHT = ".rule.weight";
    public static final String RULE_QUERY = ".rule.query";
    public static final String RULE_SELECTIVE_QUERY = ".rule.selectiveQuery";
    public static final String RULE_CLASS = ".rule.class";
    public static final String RULE_GROUPS = ".rule.groups";
    public static final String RULE_DESCRIPTION = ".rule.description";
    public static final String RULE_PARAMS = ".rule.params";
    public static final String RULE_INPUTS = ".rule.inputs";
    public static final String GROUP_NAME = ".group.name";
    public static final String GROUP_DESCRIPTION = ".group.description";
    public static final String GROUP_PARENT_GROUP_ID = ".group.parent";
    public static final String INPUT_NAME = ".input.name";
    public static final String INPUT_KEY = ".input.key";
    public static final String INPUT_QUERY = ".input.query";
    public static final String INPUT_FORMAT = ".input.firstColumnType";
    public static final String PARAM_NAME = ".param.name";
    public static final String PARAM_DEF_VALUE = ".param.default.value";
    public static final String PARAM_KEY = ".param.key";
    public static final String PARAM_QUERY = ".param.query";
    public static final String PARAM_LENGTH = ".param.length";
    public static final String PARAM_PATTERN = ".param.pattern";
    public static final String PARAM_VAL_LESS = ".param.value.lessThan";
    public static final String PARAM_VAL_GREATER = ".param.value.greaterThan";
    public static final String PARAM_PREFFIX = ".param.preffix";
    public static final String PARAM_SUFFIX = ".param.suffix";
    public static final String RULE_PREFFIX = ".id.coding.rule.";
    public static final String TOP_GROUP_NAME = "top.group";
    public static final String WEIGHT_PREFIX = ".weight";
    public static final String PARAM_SUBSTRING = ".param.";
    private static final String EXTERNAL_QUERY_RULE_CLASS = "com.ez.codingrules.cobol.ExternalQueryRule";
    private static final String GROUP_RULE_CLASS = "com.ez.codingrules.cobol.GroupRule";
    public static final String LOCATION_TITLE = ".locationTitle";
    public static final Integer DEFAULT_RULE_WEIGHT = new Integer(1);
    private static final String QUERY_ALL_COBOL = "SELECT als.ProgramID, als.AliasName AS ProgramName, Paths.PathStr FROM Programs AS pgm \tINNER JOIN ProgramAliases AS als \t\tON pgm.ProgramID = als.ProgramId \t\tAND als.AliasType = 0 \tLEFT OUTER JOIN ( SELECT 1 AS Flag, AliasName, ProgramTypeID \t\tFROM Programs  \t\tINNER JOIN ProgramAliases \t\t\tON Programs.ProgramID = ProgramAliases.ProgramId and ProgramAliases.AliasType = 0 \t    GROUP BY AliasName, ProgramTypeID \t    HAVING COUNT(*) > 1           ) f \tON f.AliasName = als.AliasName AND f.ProgramTypeID = pgm.ProgramTypeID  LEFT JOIN Occurrences \t\tON pgm.OccurId = Occurrences.OccurId LEFT JOIN Paths \t\tON Paths.PathId = Occurrences.PathID AND f.Flag = 1 WHERE pgm.ProgramTypeID = 1 \tAND pgm.occurid > 0 ";
    private Properties codingProperties;
    private List<RuleParameter> predefinedParameters;
    private Map<String, String> predefinedInputs;
    private String fileEncoding;
    private File path = null;
    private Properties driversMapping;

    public RulesManager() {
        this(null, null);
        HashMap<String, String> predefinedInputs = new HashMap<String, String>();
        predefinedInputs.put("allCobolPrograms", QUERY_ALL_COBOL);
        this.setPredefinedInputs(predefinedInputs);
    }

    public RulesManager(List<RuleParameter> predefinedParameters, Map<String, String> predefinedInputs) {
        this.predefinedParameters = predefinedParameters;
        this.setPredefinedInputs(predefinedInputs);
    }

    private void setPredefinedInputs(Map<String, String> predefinedInputs) {
        this.predefinedInputs = predefinedInputs;
    }

    public void initRules(Reader reader) {
        this.codingProperties = new Properties();
        try {
            this.codingProperties.load(reader);
            HashMap<String, String> parametersInfoMap = new HashMap<String, String>();
            HashMap<String, String> inputsInfoMap = new HashMap<String, String>();
            for (Object k : this.codingProperties.keySet()) {
                String id;
                String key = (String)k;
                if (key.endsWith(PARAM_KEY)) {
                    id = this.extractId(PARAM_KEY, key);
                    parametersInfoMap.put(this.codingProperties.getProperty(key), id);
                    continue;
                }
                if (!key.endsWith(INPUT_KEY)) continue;
                id = this.extractId(INPUT_KEY, key);
                inputsInfoMap.put(this.codingProperties.getProperty(key), id);
            }
            HashMap<String, RuleInput> inputs = new HashMap<String, RuleInput>();
            HashSet<Rule> rules = new HashSet<Rule>();
            HashMap<String, Rule> groupsMap = new HashMap<String, Rule>();
            this.root = this.getRule(ROOT_ID, GROUP_RULE_CLASS);
            this.driversMapping = PathMappingUtils.getDrivesMapping(null);
            Set<String> propertiesKeys = this.codingProperties.stringPropertyNames();
            for (String key : propertiesKeys) {
                String name = this.codingProperties.getProperty(key);
                if (key.contains(GROUP_NAME)) {
                    String parentGroupId;
                    if (name.trim().isEmpty()) {
                        L.error("group will be ignored becouse name cannot be read.");
                        continue;
                    }
                    String string = key.substring(0, key.indexOf(GROUP_NAME));
                    Rule codingRule = this.getRule(name, GROUP_RULE_CLASS);
                    codingRule.setId(string);
                    codingRule.setGroup(true);
                    String description = this.codingProperties.getProperty(string.concat(GROUP_DESCRIPTION));
                    if (description != null && description.length() > 0) {
                        codingRule.setDescription(description);
                    }
                    if ((parentGroupId = this.codingProperties.getProperty(string.concat(GROUP_PARENT_GROUP_ID))) != null && parentGroupId.length() > 0) {
                        codingRule.addGuiParentID(parentGroupId);
                    }
                    groupsMap.put(string, codingRule);
                    continue;
                }
                if (!key.contains(RULE_NAME)) continue;
                if (name.trim().isEmpty()) {
                    L.error("rule will be ignored because name cannot be read.");
                    continue;
                }
                String string = key.substring(0, key.indexOf(RULE_NAME));
                String className = this.codingProperties.getProperty(string.concat(RULE_CLASS));
                Rule codingRule = this.getRule(name, className);
                if (codingRule != null) {
                    boolean ignoreRule = this.handleParams(parametersInfoMap, string, codingRule);
                    if (!ignoreRule) {
                        ignoreRule = this.handleInputs(inputsInfoMap, string, codingRule, inputs);
                        if (ignoreRule) continue;
                        codingRule.setId(string);
                        this.handleDescription(string, codingRule);
                        this.handleSourceBased(string, codingRule);
                        this.handleWeight(string, codingRule);
                        boolean queryMustExists = className == null || className.trim().isEmpty();
                        ignoreRule = this.handleQueryFile(string, codingRule, queryMustExists);
                        if (ignoreRule) continue;
                        this.handleGroups(string, codingRule);
                        rules.add(codingRule);
                        continue;
                    }
                    L.error("rule {} will be ignored because parameter is not defined.", (Object)name);
                    continue;
                }
                L.error("rule {} will be ignored because class cannot be found", (Object)name);
            }
            for (Rule r : rules) {
                Set<String> parentIds = r.getGuiParentID();
                if (!parentIds.isEmpty()) {
                    for (String string : parentIds) {
                        Rule group = (Rule)groupsMap.get(string);
                        if (group != null) {
                            group.addChild(r, true);
                            continue;
                        }
                        this.root.addChild(r, true);
                        L.error("rule {} cannot be added to group {}, so will be added on first level", (Object)r.getName(), (Object)string);
                    }
                    continue;
                }
                this.root.addChild(r, true);
            }
            for (Rule group : groupsMap.values()) {
                for (String pId : group.getGuiParentID()) {
                    Rule pgroup = (Rule)groupsMap.get(pId);
                    if (pgroup != null) {
                        pgroup.addChild(group, true);
                        continue;
                    }
                    this.root.addChild(group, true);
                    L.error("group {} cannot be added to group {}, so will be added on first level", (Object)group.getName(), (Object)pId);
                }
            }
            for (Rule group : groupsMap.values()) {
                if (!group.getGuiParentID().isEmpty()) continue;
                L.debug("group without parent: {}", (Object)group.getName());
                boolean hasRule = false;
                Set<Rule> set = group.getChildren();
                HashSet<Rule> children = new HashSet<Rule>();
                if (set != null) {
                    children.addAll(set);
                }
                while (!hasRule && !children.isEmpty()) {
                    HashSet<Rule> localChildren = new HashSet<Rule>();
                    for (Rule child : children) {
                        if (!child.isGroup()) {
                            hasRule = true;
                            break;
                        }
                        if (child.getChildren() == null) continue;
                        localChildren.addAll(child.getChildren());
                    }
                    if (hasRule) continue;
                    children.clear();
                    children.addAll(localChildren);
                }
                if (hasRule) {
                    this.root.addChild(group, true);
                    continue;
                }
                L.debug("group {} will be ignored in wizard because has not rules", (Object)group.getName());
            }
        }
        catch (IOException e) {
            L.error("cannot read stream", (Throwable)e);
        }
    }

    private String extractId(String suffix, String key) {
        String id = key.substring(0, key.indexOf(suffix));
        return id;
    }

    private void handleGroups(String ruleIdString, Rule codingRule) {
        String groups = this.codingProperties.getProperty(ruleIdString.concat(RULE_GROUPS));
        if (groups != null && groups.length() > 0) {
            String[] groupsArrray;
            String[] stringArray = groupsArrray = groups.split(",");
            int n = groupsArrray.length;
            int n2 = 0;
            while (n2 < n) {
                String groupId = stringArray[n2];
                codingRule.addGuiParentID(groupId.trim());
                ++n2;
            }
        }
    }

    private void handleDescription(String ruleIdString, Rule codingRule) {
        String description = this.codingProperties.getProperty(ruleIdString.concat(RULE_DESCRIPTION));
        if (description != null && description.length() > 0) {
            codingRule.setDescription(description);
        }
    }

    private void handleSourceBased(String ruleIdString, Rule codingRule) {
        String sourceBased = this.codingProperties.getProperty(ruleIdString.concat(RULE_SOURCE_BASED));
        if ("false".equalsIgnoreCase(sourceBased)) {
            codingRule.setSourceBased(false);
        }
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    private Rule getRule(String ruleName, String className) {
        Rule codingRule = null;
        if (className == null || className.trim().isEmpty()) {
            className = EXTERNAL_QUERY_RULE_CLASS;
        }
        try {
            Class<?> clazz;
            try {
                clazz = Activator.class.getClassLoader().loadClass(className);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                clazz = Class.forName(className);
            }
            codingRule = (Rule)clazz.getConstructor(String.class).newInstance(ruleName);
        }
        catch (Exception e) {
            L.error("error at instantiate rule {}", (Object)ruleName, (Object)e);
            L.info("skipping rule {}", (Object)ruleName);
            return null;
        }
        codingRule.setFileEncoding(this.getFileEncoding());
        return codingRule;
    }

    private void handleWeight(String id, Rule codingRule) {
        String weight = this.codingProperties.getProperty(String.valueOf(id) + RULE_WEIGHT);
        int defaultWeightInt = DEFAULT_RULE_WEIGHT;
        if (weight != null && weight.trim().length() > 0) {
            try {
                defaultWeightInt = Integer.parseInt(weight.trim());
            }
            catch (NumberFormatException e) {
                L.warn("Parse exception caused by non integer value of weight", (Throwable)e);
            }
        }
        codingRule.setWeight(defaultWeightInt);
    }

    private boolean handleInputs(Map<String, String> inputsInfoMap, String ruleid, Rule codingRule, Map<String, RuleInput> inputs) {
        String inputsProp = this.codingProperties.getProperty(String.valueOf(ruleid) + RULE_INPUTS);
        if (inputsProp != null && !inputsProp.trim().isEmpty()) {
            String[] inputArray;
            String[] stringArray = inputArray = inputsProp.split(",");
            int n = inputArray.length;
            int n2 = 0;
            while (n2 < n) {
                String inputKey = stringArray[n2];
                String inputKeyTrim = inputKey.trim();
                RuleInput inp = inputs.get(inputKeyTrim);
                String idTrim = inputsInfoMap.get(inputKeyTrim);
                if (idTrim == null) {
                    L.warn("rule with input without definition - rule id = {}", (Object)ruleid);
                    return true;
                }
                if (inp == null) {
                    String format = "numeric";
                    String name = this.codingProperties.getProperty(idTrim.concat(INPUT_NAME));
                    inp = new RuleInput(name);
                    inp.setId(idTrim);
                    String key = this.codingProperties.getProperty(idTrim.concat(INPUT_KEY));
                    inp.setKey(key);
                    if (this.predefinedInputs.containsKey(key)) {
                        String query = this.predefinedInputs.get(key);
                        inp.setQuery(query);
                    } else {
                        String queryPath = this.codingProperties.getProperty(idTrim.concat(INPUT_QUERY));
                        if ((queryPath = this.getRealPath(queryPath)) == null || queryPath.trim().isEmpty()) {
                            L.warn("rule with input without query - rule id = {} - input.key = {}", (Object)ruleid, (Object)key);
                            return true;
                        }
                        String content = RulesManager.readFileContent(queryPath, codingRule.getFileEncoding());
                        inp.setQuery(content);
                        format = this.codingProperties.getProperty(idTrim.concat(INPUT_FORMAT), "numeric");
                    }
                    inp.setFormat(format.equals("numeric"));
                    inputs.put(idTrim, inp);
                }
                codingRule.addInput(idTrim, inp);
                ++n2;
            }
        }
        return false;
    }

    private boolean handleParams(Map<String, String> parametersInfoMap, String ruleid, Rule codingRule) {
        String paramsProp = this.codingProperties.getProperty(String.valueOf(ruleid) + RULE_PARAMS);
        boolean ignoreRule = false;
        if (paramsProp != null && !paramsProp.trim().isEmpty()) {
            String[] paramArray;
            String[] stringArray = paramArray = paramsProp.split(",");
            int n = paramArray.length;
            int n2 = 0;
            while (n2 < n) {
                String valueLess;
                String valueGreater;
                String paramKey = stringArray[n2];
                String paramKeyTrim = paramKey.trim();
                if (!parametersInfoMap.containsKey(paramKeyTrim)) {
                    ignoreRule = true;
                    L.warn("rule with parameter without definition - rule id = {}", (Object)ruleid);
                    break;
                }
                String paramId = parametersInfoMap.get(paramKeyTrim);
                String name = this.codingProperties.getProperty(paramId.concat(PARAM_NAME));
                RuleParameter p = new RuleParameter(name);
                String defvalue = this.codingProperties.getProperty(paramId.concat(PARAM_DEF_VALUE));
                p.setValue(defvalue);
                p.setId(paramId);
                String key = this.codingProperties.getProperty(paramId.concat(PARAM_KEY));
                p.setKey(key);
                String length = this.codingProperties.getProperty(paramId.concat(PARAM_LENGTH));
                if (length != null) {
                    try {
                        Integer l = Integer.parseInt(length);
                        p.setLength(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        L.warn("parameter length is not a number: {}", (Object)name);
                    }
                }
                if ((valueGreater = this.codingProperties.getProperty(paramId.concat(PARAM_VAL_GREATER))) != null) {
                    try {
                        Integer l = Integer.parseInt(valueGreater);
                        p.setValueGreater(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        L.warn("parameter valueGreater is not a number: {}", (Object)name);
                    }
                }
                if ((valueLess = this.codingProperties.getProperty(paramId.concat(PARAM_VAL_LESS))) != null) {
                    try {
                        Integer l = Integer.parseInt(valueLess);
                        p.setValueLess(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        L.warn("parameter valueLess is not a number: {}", (Object)name);
                    }
                }
                String patt = this.codingProperties.getProperty(paramId.concat(PARAM_PATTERN));
                p.setPattern(patt);
                codingRule.addParameter(name, p);
                ++n2;
            }
        }
        if (!ignoreRule && this.predefinedParameters != null) {
            for (RuleParameter rp : this.predefinedParameters) {
                codingRule.addParameter(rp.getName(), rp);
            }
        }
        return ignoreRule;
    }

    public static String readFileContent(String path) {
        return RulesManager.readFileContent(path, "UTF-8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileContent(String path, String encoding) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        String query = null;
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            Reader reader = null;
            try {
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                    StringBuffer srcBuf = new StringBuffer();
                    char[] buf = new char[512];
                    while (reader.ready()) {
                        int read = reader.read(buf, 0, 512);
                        if (read <= -1) continue;
                        srcBuf.append(new String(buf, 0, read));
                    }
                    query = srcBuf.toString();
                    return query;
                }
                catch (IOException ioex) {
                    L.error("get query from {}", (Object)file, (Object)ioex);
                    if (reader == null) return query;
                    try {
                        reader.close();
                        return query;
                    }
                    catch (IOException e) {
                        L.error("close file {}", (Object)file, (Object)e);
                    }
                }
                return query;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        L.error("close file {}", (Object)file, (Object)e);
                    }
                }
            }
        }
        L.warn("file not exists: {}", (Object)file);
        return query;
    }

    private boolean handleQueryFile(String id, Rule codingRule, boolean queryMustExists) {
        boolean ignoreRule = false;
        String path = this.codingProperties.getProperty(String.valueOf(id) + RULE_QUERY);
        if ((path = this.getRealPath(path)) != null) {
            codingRule.setQueryFile(path);
        } else if (queryMustExists) {
            ignoreRule = true;
        }
        path = this.codingProperties.getProperty(String.valueOf(id) + RULE_SELECTIVE_QUERY);
        path = this.getRealPath(path);
        if (path != null) {
            codingRule.setSelectiveQueryFile(path);
        }
        return ignoreRule;
    }

    private String getRealPath(String path) {
        if (path != null && !path.trim().isEmpty()) {
            String rpath = PathMappingUtils.getAbsolutePath((String)this.path.getAbsolutePath(), (String)path);
            if ((rpath = PathMappingUtils.convertToMapped((String)rpath, (Properties)this.driversMapping)) != null) {
                File f = new File(rpath);
                if (f != null && f.exists()) {
                    rpath = f.getAbsolutePath();
                } else {
                    L.warn("path {} not exists or is not accessible!", (Object)rpath);
                }
            }
            return rpath;
        }
        return null;
    }

    public Rule getInput() {
        return this.root;
    }

    public List<Rule> getTopLevelGroups() {
        ArrayList<Rule> l = new ArrayList<Rule>();
        if (this.root.getChildren() != null) {
            l.addAll(this.root.getChildren());
        }
        return l;
    }

    public static boolean isAlphanumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetterOrDigit(str.charAt(i)) && str.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setFilePath(File parentFile) {
        this.path = parentFile;
    }
}

