/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules;

import com.ez.codingrules.internal.Messages;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public class RuleParameter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String name;
    private String id;
    private String key;
    private String pattern;
    private Integer length;
    private Integer valueLess;
    private Integer valueGreater;
    private String prefix;
    private String suffix;
    private String includeKey = "0";
    private String value = null;

    public RuleParameter(String name) {
        Assert.isNotNull((Object)name);
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getValueLess() {
        return this.valueLess;
    }

    public void setValueLess(Integer valueLess) {
        this.valueLess = valueLess;
    }

    public Integer getValueGreater() {
        return this.valueGreater;
    }

    public void setValueGreater(Integer valueGreater) {
        this.valueGreater = valueGreater;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getIncludeKey() {
        return this.includeKey;
    }

    public void setIncludeKey(String includeKey) {
        this.includeKey = includeKey;
    }

    public String getName() {
        return this.name;
    }

    public String isValid(String param) {
        if (param.isEmpty()) {
            return Messages.getString(RuleParameter.class, "is.valid.no.empty");
        }
        if (this.length != null && param.length() != this.length.intValue()) {
            return Messages.getString(RuleParameter.class, "is.valid.match.length", new String[]{this.length.toString()});
        }
        if (this.valueGreater != null || this.valueLess != null) {
            Integer paramInt = null;
            try {
                paramInt = Integer.parseInt(param);
            }
            catch (NumberFormatException numberFormatException) {
                return Messages.getString(RuleParameter.class, "is.valid.number");
            }
            if (this.valueGreater != null && paramInt <= this.valueGreater) {
                return Messages.getString(RuleParameter.class, "is.valid.greater.than", new String[]{this.valueGreater.toString()});
            }
            if (this.valueLess != null && paramInt >= this.valueLess) {
                return Messages.getString(RuleParameter.class, "is.valid.less.than", new String[]{this.valueLess.toString()});
            }
        }
        if (this.pattern != null && !this.pattern.isEmpty() && !Pattern.matches(this.pattern, param)) {
            return Messages.getString(RuleParameter.class, "is.valid.pattern", new String[]{this.pattern});
        }
        return "";
    }
}

