/*
 * Decompiled with CFR 0.152.
 */
package com.ez.codingrules;

import com.ez.codingrules.RuleInput;
import com.ez.codingrules.RuleParameter;
import com.ez.codingrules.RuleResult;
import com.ez.codingrules.RulesManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Rule
implements Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Rule.class);
    private boolean isGroup = false;
    private String name;
    private String descriptionPath;
    protected Set<String> guiParentID = new HashSet<String>();
    private String customerId;
    private String groupName;
    private String imagePath;
    private String queryFile;
    private String selectiveQueryFile;
    private boolean sourceBased = true;
    private String query;
    private Set<Rule> children;
    private Set<Rule> parents = new HashSet<Rule>();
    protected boolean checked = true;
    protected String id;
    protected Set<Integer> applicableResurceType = new HashSet<Integer>();
    protected String description;
    protected Integer weight = new Integer(0);
    protected Map<String, RuleInput> inputs;
    protected Map<String, RuleParameter> parameters;
    protected String locTitle;
    private String queryFileEncoding;

    protected Rule() {
    }

    public Rule(String name) {
        this.name = name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptionPath() {
        return this.descriptionPath;
    }

    public Set<Rule> getChildren() {
        return this.children;
    }

    public Set<Rule> getParents() {
        return this.parents;
    }

    public void setGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public void setDescriptionPath(String descriptionPath) {
        this.descriptionPath = descriptionPath;
    }

    public void addChild(Rule child, boolean setParent) {
        if (this.children == null) {
            this.children = new HashSet<Rule>();
        }
        this.children.add(child);
        if (setParent) {
            child.addParent(this);
        }
    }

    public void addParent(Rule parent) {
        this.parents.add(parent);
    }

    public void addGuiParentID(String parentId) {
        this.guiParentID.add(parentId);
    }

    public Set<String> getGuiParentID() {
        return this.guiParentID;
    }

    public void setChecked(boolean executeIt) {
        this.checked = executeIt;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSourceBased() {
        return this.sourceBased;
    }

    public void setSourceBased(boolean sourceBased) {
        this.sourceBased = sourceBased;
    }

    public Set<Integer> getApplicableResurceType() {
        return this.applicableResurceType;
    }

    public void setApplicableResurceType(Set<Integer> applicableResurceType) {
        this.applicableResurceType = applicableResurceType;
    }

    public abstract RuleResult execute(IProgressMonitor var1, Map<String, Object> var2);

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getQuery() {
        String content;
        if (this.query == null && this.queryFile != null && (content = RulesManager.readFileContent(this.queryFile, this.getFileEncoding())) != null) {
            this.query = content;
        }
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public boolean hasInputs() {
        return this.inputs != null && !this.inputs.isEmpty();
    }

    public Map<String, RuleInput> getInputs() {
        return this.inputs;
    }

    public void addInput(String inputID, RuleInput inpValue) {
        if (this.inputs == null) {
            this.inputs = new HashMap<String, RuleInput>();
        }
        this.inputs.put(inputID, inpValue);
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public Map<String, RuleParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(String paramName, RuleParameter paramValue) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, RuleParameter>();
        }
        this.parameters.put(paramName, paramValue);
    }

    public String getParametersDescription() {
        String ret = "";
        if (!this.hasParameters()) {
            return ret;
        }
        for (String paramName : this.parameters.keySet()) {
            RuleParameter param = this.parameters.get(paramName);
            if (!ret.isEmpty()) {
                ret = ret.concat("\n");
            }
            ret = ret.concat(String.valueOf(paramName) + " is " + param.getValue());
        }
        return ret;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String getSelectiveQueryFile() {
        return this.selectiveQueryFile;
    }

    public void setSelectiveQueryFile(String selectiveQueryFile) {
        this.selectiveQueryFile = selectiveQueryFile;
    }

    public void setLocationTitle(String locTitle) {
        this.locTitle = locTitle;
    }

    public String getLocationTitle() {
        return this.locTitle;
    }

    public String toString() {
        return this.name;
    }

    public void setFileEncoding(String fileEncoding) {
        this.queryFileEncoding = fileEncoding;
    }

    public String getFileEncoding() {
        return this.queryFileEncoding;
    }
}

