/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.start;

import com.ez.analysis.base.Activator;
import com.ez.analysis.base.explore.folders.ExploreFoldersDescriptor;
import com.ez.analysis.base.internal.Messages;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.actions.NullContext;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(StartViewer.class);

    public Composite create(Composite parent, IAction action, final IActionManager manager) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, true);
        gl.marginHeight = 30;
        gl.marginWidth = 30;
        gl.verticalSpacing = 15;
        gl.horizontalSpacing = 15;
        composite.setLayout((Layout)gl);
        Button explore = new Button(composite, 8);
        explore.setText(Messages.getString(StartViewer.class, "exploreProjects.button"));
        explore.setImage(Activator.getImageDescriptor("icons/exploration.png").createImage());
        explore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                L.debug("explore projects ...");
                manager.launch("com.ez.analysis.base.explore.projects", (IActionContext)new NullContext("com.ez.analysis.base.start"));
            }
        });
        this.setGridData(explore);
        Button search = new Button(composite, 8);
        search.setText(Messages.getString(StartViewer.class, "searchElements.button"));
        search.setImage(Activator.getImageDescriptor("icons/search.png").createImage());
        search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                L.debug("search elements ...");
            }
        });
        this.setGridData(search);
        Button reports = new Button(composite, 8);
        reports.setText(Messages.getString(StartViewer.class, "generateReports.button"));
        reports.setImage(Activator.getImageDescriptor("icons/report.png").createImage());
        reports.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                L.debug("generate reports ...");
                manager.launch(ExploreFoldersDescriptor.EXPLORE_FOLDERS, (IActionContext)new NullContext("com.ez.analysis.base.start"));
            }
        });
        this.setGridData(reports);
        Button graphs = new Button(composite, 8);
        graphs.setText(Messages.getString(StartViewer.class, "generateGraphs.button"));
        graphs.setImage(Activator.getImageDescriptor("icons/graph.png").createImage());
        graphs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                L.debug("generate graphs ...");
                manager.launch(ExploreFoldersDescriptor.EXPLORE_FOLDERS, (IActionContext)new NullContext("com.ez.analysis.base.start"));
            }
        });
        this.setGridData(graphs);
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                composite.layout();
            }
        });
        return composite;
    }

    private void setGridData(Button element) {
        GridData gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        gd.minimumHeight = 130;
        gd.minimumWidth = 200;
        element.setLayoutData((Object)gd);
    }
}

