/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.projects.service.impl;

import com.ez.analysis.base.Activator;
import com.ez.analysis.base.project.ProjectInfoConfigurator;
import com.ez.analysis.base.project.ProjectProvider;
import com.ez.analysis.base.projects.service.IProjectsChangeListener;
import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.internal.model.MFProjListChangedListener;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.ProjectType;
import com.ibm.ad.oauth2.AuthenticationEvent;
import com.ibm.ad.oauth2.AuthenticationStatusListener;
import com.ibm.ad.oauth2.service.SSOService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectsServiceImpl
implements IProjectsService,
AuthenticationStatusListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectsServiceImpl.class);
    private Map<ProjectType, ImageDescriptor> imgDescriptors = new HashMap<ProjectType, ImageDescriptor>(){
        {
            this.put(ProjectType.abap, Activator.getImageDescriptor("icons/project_abap.png"));
            this.put(ProjectType.nw, Activator.getImageDescriptor("icons/project_netweaver.png"));
            this.put(ProjectType.c, Activator.getImageDescriptor("icons/project_c.png"));
            this.put(ProjectType.csharp, Activator.getImageDescriptor("icons/project_csharp.png"));
            this.put(ProjectType.java, Activator.getImageDescriptor("icons/project_java.png"));
            this.put(ProjectType.javaWazi, Activator.getImageDescriptor("icons/project_java_wazi.png"));
            this.put(ProjectType.jdt, Activator.getImageDescriptor("icons/folder-jdt.png"));
            this.put(ProjectType.vme, Activator.getImageDescriptor("icons/project_fujitsu.png"));
            this.put(ProjectType.zos, Activator.getImageDescriptor("icons/project_zos.png"));
            this.put(ProjectType.vse, Activator.getImageDescriptor("icons/project_vse.png"));
            this.put(ProjectType.smart, Activator.getImageDescriptor("icons/project_smart.png"));
            this.put(ProjectType.mainframe, Activator.getImageDescriptor("icons/folder-blue.png"));
            this.put(ProjectType.other, Activator.getImageDescriptor("icons/folder-yellow.png"));
        }
    };
    List<ProjectInfo> projects = Collections.synchronizedList(new ArrayList());
    private ProjectInfoConfigurator pic;
    private IResourceChangeListener resourceListener;
    private Set<IProjectsChangeListener> listeners = Collections.synchronizedSet(new HashSet());
    private static int refreshcount = 0;

    public ProjectsServiceImpl() {
        this.pic = new ProjectInfoConfigurator(){

            @Override
            public void configure(ProjectInfo pi) {
                Map<ProjectType, ImageDescriptor> imgDescriptors = ProjectsServiceImpl.this.getImgDescriptors();
                pi.setDescriptor(imgDescriptors.get(pi.getType()));
            }
        };
        this.resourceListener = this.handleWorkspaceChanges();
        SSOService ssos = (SSOService)ServiceUtils.getService(SSOService.class);
        if (ssos == null) {
            L.error("could not get SSOService");
        } else {
            ssos.addListener((AuthenticationStatusListener)this);
        }
    }

    @Override
    public Map<ProjectType, ImageDescriptor> getImgDescriptors() {
        return this.imgDescriptors;
    }

    @Override
    public List<ProjectInfo> getProjects() {
        return new ArrayList<ProjectInfo>(this.projects);
    }

    @Override
    public void refresh(IProgressMonitor pmonitor) {
        if (pmonitor == null) {
            pmonitor = new NullProgressMonitor();
        }
        this.reloadList(pmonitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadList(IProgressMonitor pmonitor, boolean addListener) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        ArrayList<ProjectInfo> tempProjects = new ArrayList<ProjectInfo>();
        List<ProjectProvider> ppl = Activator.getDefault().getProjectProviders();
        if (ppl != null) {
            L.trace("reload; project providers no: {}", (Object)ppl.size());
            monitor.setWorkRemaining(ppl.size());
            for (ProjectProvider pp : ppl) {
                try {
                    L.trace("pp={}; addListener={}; tempProjects={}", new Object[]{pp, addListener, tempProjects});
                    pp.loadProjects(tempProjects, this.pic, (IProgressMonitor)monitor.newChild(1));
                    if (!addListener) continue;
                    pp.addListener(new MFProjListChangedListener(){

                        public void listChanged() {
                            L.debug("list of projects was changed");
                            ProjectsServiceImpl.this.reloadList((IProgressMonitor)new NullProgressMonitor(), false);
                            ProjectsServiceImpl.this.notifyListeners();
                        }
                    });
                }
                catch (Exception e) {
                    L.error("could not handle project provider {}", (Object)pp, (Object)e);
                }
            }
        } else {
            monitor.setWorkRemaining(0);
            L.error("no project providers");
        }
        L.trace("tempProjects={}", tempProjects);
        List<ProjectInfo> list = this.projects;
        synchronized (list) {
            this.projects.clear();
            this.projects.addAll(tempProjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(AuthenticationEvent event) {
        List<ProjectInfo> list = this.projects;
        synchronized (list) {
            this.projects.clear();
        }
        this.notifyListeners();
        ++refreshcount;
        new RefreshThread(event.toString()).start();
    }

    private void removeFromList(List<ProjectInfo> list, IProject prj) {
        if (list != null) {
            ProjectInfo piFound = null;
            for (ProjectInfo pi : list) {
                if (!pi.isEclipse() || !pi.getPrj().equals((Object)prj)) continue;
                piFound = pi;
                break;
            }
            if (piFound != null) {
                list.remove(piFound);
            }
        }
    }

    private ProjectInfo createProjectInfo(IProject prj) {
        ProjectInfo pi = null;
        Activator bundle = Activator.getDefault();
        if (bundle != null) {
            List<ProjectProvider> ppl = bundle.getProjectProviders();
            if (ppl != null) {
                for (ProjectProvider pp : ppl) {
                    pi = pp.createInfo(prj, this.pic);
                    if (pi == null) {
                        continue;
                    }
                    break;
                }
            } else {
                L.error("no project providers");
            }
        }
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(Set<IProject> changedProjects) {
        ArrayList<ProjectInfo> stateProjects = new ArrayList<ProjectInfo>();
        stateProjects.addAll(this.getProjects());
        for (IProject changed : changedProjects) {
            ProjectInfo pi;
            this.removeFromList(stateProjects, changed);
            if (!changed.isAccessible() || (pi = this.createProjectInfo(changed)) == null) continue;
            stateProjects.add(pi);
        }
        List<ProjectInfo> list = this.projects;
        synchronized (list) {
            this.projects.clear();
            this.projects.addAll(stateProjects);
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (IProjectsChangeListener listener : this.listeners) {
            listener.projectsChanged();
        }
    }

    private IResourceChangeListener handleWorkspaceChanges() {
        final ProjectDeltaVisitor visitor = new ProjectDeltaVisitor();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1) {
                    IResourceDelta delta = event.getDelta();
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                        ProjectsServiceImpl.this.changeState(visitor.changedProjects);
                        visitor.changedProjects.clear();
                    }
                    catch (CoreException e) {
                        L.warn("when handling resource change event {}", (Object)event, (Object)e);
                    }
                }
            }
        };
        workspace.addResourceChangeListener(listener);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.resourceListener);
        List<ProjectInfo> list = this.projects;
        synchronized (list) {
            this.projects.clear();
        }
    }

    @Override
    public void registerChangeListener(IProjectsChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterChangeListener(IProjectsChangeListener listener) {
        this.listeners.remove(listener);
    }

    class ProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        public Set<IProject> changedProjects = new HashSet<IProject>();

        ProjectDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean ret = false;
            IResource r = delta.getResource();
            switch (r.getType()) {
                case 4: {
                    ret = false;
                    this.changedProjects.add((IProject)r);
                    break;
                }
                case 8: {
                    ret = true;
                }
            }
            return ret;
        }

        public void clear() {
            this.changedProjects.clear();
        }
    }

    class RefreshThread
    extends Thread {
        public RefreshThread(String name) {
            super("refresh project list: " + refreshcount + "; event(" + name + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)new NullProgressMonitor());
            ArrayList tempProjects = new ArrayList();
            List<ProjectProvider> ppl = Activator.getDefault().getProjectProviders();
            if (ppl != null) {
                L.trace("refresh; project providers no: {}", (Object)ppl.size());
                monitor.setWorkRemaining(ppl.size());
                for (ProjectProvider pp : ppl) {
                    try {
                        pp.identityChanged();
                    }
                    catch (Exception e) {
                        L.error("could not handle project provider {}", (Object)pp, (Object)e);
                    }
                }
            } else {
                monitor.setWorkRemaining(0);
                L.error("no project providers");
            }
            List<ProjectInfo> list = ProjectsServiceImpl.this.projects;
            synchronized (list) {
                ProjectsServiceImpl.this.projects.clear();
                ProjectsServiceImpl.this.projects.addAll(tempProjects);
            }
        }
    }
}

