/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.project.property.sections;

import com.ez.analysis.base.internal.Messages;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.mainframe.model.ProjectInfo;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectSection.class);
    ProjectInfo pInfo;
    private Text prjType;
    private Text txtEnvironment;
    private Text txtLocation;
    private Text txtMetadata;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        this.composite.setLayout((Layout)grid);
        this.getWidgetFactory().createCLabel(this.composite, Messages.getString(ProjectSection.class, "label.resource.type"));
        this.prjType = this.getWidgetFactory().createText(this.composite, Messages.getString(ProjectSection.class, "text.resource.type"), 8);
        this.getWidgetFactory().createCLabel(this.composite, Messages.getString(ProjectSection.class, "label.environment"));
        this.txtEnvironment = this.getWidgetFactory().createText(this.composite, "", 8);
        this.getWidgetFactory().createCLabel(this.composite, Messages.getString(ProjectSection.class, "label.location"));
        this.txtLocation = this.getWidgetFactory().createText(this.composite, "", 8);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        if (this.pInfo != null && this.pInfo.getInfo() != null) {
            Map prop = this.pInfo.getInfo();
            Object prjName = prop.get("projectName");
            String environment = (String)prop.get("environment");
            if (prjName != null) {
                Object hasMainframeConn = prop.get("onMainframe");
                if (hasMainframeConn != null) {
                    Boolean onMainframe = (Boolean)hasMainframeConn;
                    L.debug(prjName + " hasMainframe=" + onMainframe);
                    if (!onMainframe.booleanValue() && environment != null && !environment.isEmpty() && environment.equals("JVM")) {
                        this.prjType.setText(Messages.getString(ProjectSection.class, "java.resource.type"));
                    } else {
                        this.prjType.setText(Messages.getString(ProjectSection.class, "text.resource.type"));
                    }
                } else {
                    L.debug(prjName + " hasMainframe=noMainfrConnection");
                }
            }
            this.txtEnvironment.setText(environment);
            this.txtLocation.setText((String)prop.get("projectLocation"));
        } else {
            this.prjType.setText(Messages.getString(ProjectSection.class, "resourceType.label"));
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.pInfo = (ProjectInfo)input;
    }
}

