/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.explore.projects;

import com.ez.analysis.base.explore.folders.ExploreFoldersDescriptor;
import com.ez.analysis.base.explore.projects.ExploreProjectsDescriptor;
import com.ez.analysis.base.explore.projects.State;
import com.ez.analysis.base.internal.Messages;
import com.ez.analysis.base.projects.service.IProjectsChangeListener;
import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.internal.analysis.config.context.AnalysisBrowserContext;
import com.ez.internal.analysis.config.inputs.EZProjectInputType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.ProjectType;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZProjectIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExploreProjectsViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExploreProjectsViewer.class);
    static final String REFRESH_CONTEXT_KEY = "REFRESH";
    public static final String ANALYSIS_TYPE_INPUTS = "ANALYSIS_TYPE_INPUTS";
    public static final String PROJECT_LIST = "PROJECT_LIST";
    public static final String PROJECT_INFO = "PROJECT_INFO";
    public static final String SCOPE = "SCOPE";
    public static final String NOT_COMPUTE_USAGE_RESULTS = "NOT_COMPUTE_USAGE_RESULTS";
    private static final String MAINFRAME_EXPLORE_ANALYSIS = "com.ez.analysis.mainframe.explore.projects";
    private ExploreProjectsDescriptor descriptor;
    private TableViewer viewer;
    private ImageRegistry ir;
    private FilterJob filterJob;

    public ExploreProjectsViewer(ExploreProjectsDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.ir = new ImageRegistry(parent.getDisplay());
        this.filterJob = new FilterJob();
        Composite c = new Composite(parent, 0);
        this.followChanges(c);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        Text txt = this.createFilter(c);
        GridData gdt = new GridData(768);
        txt.setLayoutData((Object)gdt);
        this.viewer = new TableViewer(c, 66306);
        ProjectsComparator comparator = new ProjectsComparator();
        this.viewer.setComparator((ViewerComparator)comparator);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setMenu(this.createContextMenu((Control)table, action, manager));
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProjectsLabelProvider());
        this.viewer.setInput(this.descriptor.getState().getProjects());
        int dir = comparator.getDirection();
        this.viewer.getTable().setSortDirection(dir);
        this.viewer.getTable().setSortColumn(table.getColumn(0));
        this.handleSelection(manager);
        this.handleDoubleClick(manager);
        this.handleEnterKey(manager);
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExploreProjectsViewer.this.ir.dispose();
                ExploreProjectsViewer.this.filterJob = null;
            }
        });
        return c;
    }

    private void followChanges(Composite c) {
        final IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        final IProjectsChangeListener listener = new IProjectsChangeListener(){

            @Override
            public void projectsChanged() {
                L.debug("projects list was changed; notify descriptor: {}", (Object)ExploreProjectsViewer.this.descriptor);
                State newState = new State();
                if (ExploreProjectsViewer.this.descriptor.getState() != null) {
                    newState.setOnlyAnalysis(ExploreProjectsViewer.this.descriptor.getState().isOnlyAnalysis());
                }
                newState.setProjects(service.getProjects());
                ExploreProjectsViewer.this.descriptor.setState(newState);
            }
        };
        service.registerChangeListener(listener);
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                service.unregisterChangeListener(listener);
            }
        });
    }

    private Text createFilter(Composite parent) {
        final Text txt = new Text(parent, 388);
        txt.setMessage(Messages.getString(ExploreProjectsViewer.class, "projects.filter.message"));
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExploreProjectsViewer.this.filterJob.cancel();
                ExploreProjectsViewer.this.filterJob.setFilter(txt.getText());
                ExploreProjectsViewer.this.filterJob.schedule(100L);
            }
        });
        txt.setToolTipText(Messages.getString(ExploreProjectsViewer.class, "projects.filter.tooltip"));
        txt.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExploreProjectsViewer.this.filterJob.cancel();
                ExploreProjectsViewer.this.filterJob.setFilter(txt.getText());
                ExploreProjectsViewer.this.filterJob.schedule(100L);
            }
        });
        return txt;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{Messages.getString(ExploreProjectsViewer.class, "project.columnName"), Messages.getString(ExploreProjectsViewer.class, "type.columnName"), Messages.getString(ExploreProjectsViewer.class, "details.columnName"), Messages.getString(ExploreProjectsViewer.class, "metadata.columnName")};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 16384);
            TableColumn tc = column.getColumn();
            tc.setText(titles[i]);
            if (i == 0) {
                tc.setWidth(DpiScaler.getScaledSize((int)170));
            } else {
                tc.setWidth(DpiScaler.getScaledSize((int)100));
            }
            tc.setResizable(true);
            tc.setMoveable(false);
            tc.addSelectionListener((SelectionListener)this.getSelectionAdapter(tc, i));
            ++i;
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsComparator comparator = (ProjectsComparator)ExploreProjectsViewer.this.viewer.getComparator();
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                ExploreProjectsViewer.this.viewer.getTable().setSortDirection(dir);
                ExploreProjectsViewer.this.viewer.getTable().setSortColumn(column);
                ExploreProjectsViewer.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void handleSelection(final IActionManager manager) {
        this.viewer.getTable();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                final List pInfos = ss.toList();
                final ArrayList<Object> inptTypes = new ArrayList<Object>();
                final HashSet<EZEntityID> entities = new HashSet<EZEntityID>();
                for (ProjectInfo pi : pInfos) {
                    if (!pi.isEclipse()) {
                        EZSourceProjectInputType inputType = new EZSourceProjectInputType();
                        inputType.setName(pi.getName());
                        inputType.addProperty(ExploreProjectsViewer.PROJECT_INFO, (Object)pi);
                        inputType.setContext(AnalysisBrowserContext.class);
                        EZEntityID prjEid = new EZEntityID();
                        EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(pi);
                        prjEid.addSegment((EZSegment)prjIdSg);
                        inputType.setEntID(prjEid);
                        inptTypes.add(inputType);
                        entities.add(prjEid);
                        continue;
                    }
                    EZProject ezPrj = EZWorkspace.getInstance().getPrjModel((IResource)pi.getPrj());
                    EZProjectInputType inputType = pi.getType().getObjectType();
                    EZEntityID entID = new EZEntityID();
                    if (ezPrj != null) {
                        EZProjectIDSg prjIdSg = new EZProjectIDSg(ezPrj);
                        entID.addSegment((EZSegment)prjIdSg);
                    }
                    entities.add(entID);
                    inputType.setEntID(entID);
                    inputType.setName(pi.getName());
                    inputType.addProperty(ExploreProjectsViewer.PROJECT_INFO, (Object)pi);
                    inputType.setContext(AnalysisBrowserContext.class);
                    inptTypes.add(inputType);
                }
                if (!inptTypes.isEmpty()) {
                    AbstractActionContext context = new AbstractActionContext(){

                        public Map<String, Object> getData() {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put(ExploreProjectsViewer.ANALYSIS_TYPE_INPUTS, inptTypes);
                            data.put(ExploreProjectsViewer.PROJECT_LIST, pInfos);
                            data.put(ExploreProjectsViewer.SCOPE, entities);
                            data.put("projects", ExploreProjectsViewer.this.descriptor.getState().getData().get("projects"));
                            data.put(ExploreProjectsViewer.NOT_COMPUTE_USAGE_RESULTS, Boolean.TRUE);
                            if (pInfos.size() == 1) {
                                ProjectInfo pi = (ProjectInfo)pInfos.get(0);
                                ISelection sel = ExploreProjectsViewer.this.getSelection4PropertiesView(pi);
                                if (sel != null) {
                                    data.put("selection", sel);
                                }
                            }
                            data.put("sourceView", new Pair((Object)"com.ez.analysisbrowser.views.AnalysisBrowserView", (Object)((BrowserManager)manager).getViewSecondaryId()));
                            return data;
                        }

                        public String getId() {
                            return "com.ez.analysis.base.explore.projects";
                        }
                    };
                    ExploreProjectsViewer.this.descriptor.getState().getData().putAll(context.getData());
                    manager.setCurrentContext((IActionContext)context);
                }
            }
        });
    }

    private ISelection getSelection4PropertiesView(ProjectInfo pi) {
        StructuredSelection sel = null;
        EZEntityID entID = new EZEntityID();
        if (pi.isEclipse()) {
            EZProject ezPrj = EZWorkspace.getInstance().getPrjModel((IResource)pi.getPrj());
            IProject prj = null;
            if (ezPrj != null) {
                EZProjectIDSg prjIdSg = new EZProjectIDSg(ezPrj);
                entID.addSegment((EZSegment)prjIdSg);
                prj = ezPrj.getProject();
            } else {
                prj = pi.getPrj();
            }
            sel = new StructuredSelection((Object)prj);
        } else {
            sel = new StructuredSelection((Object)pi);
        }
        return sel;
    }

    private void handleDoubleClick(final IActionManager manager) {
        final Table table = this.viewer.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ExploreProjectsViewer.this.handleExploreProjectActionEvent(manager, table);
            }
        });
    }

    private void handleEnterKey(final IActionManager manager) {
        final Table table = this.viewer.getTable();
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.keyCode == 13 && table.getSelectionCount() == 1) {
                    ExploreProjectsViewer.this.handleExploreProjectActionEvent(manager, table);
                }
            }
        });
    }

    private void handleExploreProjectActionEvent(IActionManager manager, Table table) {
        int idx = table.getSelectionIndex();
        if (idx != -1) {
            TableItem item = table.getItem(idx);
            final ProjectInfo pi = (ProjectInfo)item.getData();
            if (pi.isEclipse()) {
                final String path = pi.getPrj().getLocation().toOSString();
                manager.launch(ExploreFoldersDescriptor.EXPLORE_FOLDERS, (IActionContext)new AbstractActionContext(){

                    public Map<String, Object> getData() {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("com.ez.analysis.base.explore.projects.PROJECT", pi);
                        data.put("com.ez.analysis.base.explore.projects.rootpath", path);
                        return data;
                    }

                    public String getId() {
                        return "com.ez.analysis.base.explore.projects";
                    }
                });
            } else if (pi.getType() == null || !pi.getType().equals((Object)ProjectType.javaWazi)) {
                manager.launch(MAINFRAME_EXPLORE_ANALYSIS, (IActionContext)new AbstractActionContext(){

                    public Map<String, Object> getData() {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("com.ez.analysis.base.explore.projects.PROJECT", pi);
                        data.put("projects", ExploreProjectsViewer.this.descriptor.getState().getData().get("projects"));
                        return data;
                    }

                    public String getId() {
                        return "com.ez.analysis.base.explore.projects";
                    }
                });
            }
        }
    }

    protected Menu createContextMenu(Control c, final IAction action, final IActionManager manager) {
        Menu menu = new Menu(c);
        MenuItem refreshItem = new MenuItem(menu, 8);
        refreshItem.setText(Messages.getString(ExploreProjectsViewer.class, "refresh.menuItem"));
        refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExploreProjectsViewer.this.viewer.getTable().getSelection().length > 0) {
                    ExploreProjectsViewer.this.viewer.getTable().deselectAll();
                    ((BrowserManager)manager).setCurrentContext(null);
                }
                action.setInputContext((IActionContext)new AbstractActionContext(){

                    public Map<String, Object> getData() {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put(ExploreProjectsViewer.REFRESH_CONTEXT_KEY, true);
                        return data;
                    }

                    public String getId() {
                        return "com.ez.analysis.base.explore.projects";
                    }
                });
                manager.runInPlace(action, new IFinishedListener(){

                    public void finished(boolean canceled, Throwable t) {
                        ((BrowserManager)manager).updateTools();
                    }
                });
            }
        });
        new MenuItem(menu, 2);
        final MenuItem filterItem = new MenuItem(menu, 32);
        filterItem.setText(Messages.getString(ExploreProjectsViewer.class, "filterProjects.menuItem"));
        boolean onlyAnalysis = this.descriptor.getState().isOnlyAnalysis();
        filterItem.setSelection(onlyAnalysis);
        filterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean onlyAnalysis = filterItem.getSelection();
                ExploreProjectsViewer.this.descriptor.getState().setOnlyAnalysis(onlyAnalysis);
                ExploreProjectsViewer.this.filterJob.cancel();
                ExploreProjectsViewer.this.filterJob.setOnlyAnalysis(onlyAnalysis);
                ExploreProjectsViewer.this.filterJob.schedule(100L);
            }
        });
        return menu;
    }

    public void update() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ExploreProjectsViewer.this.viewer != null) {
                    State state = ExploreProjectsViewer.this.descriptor.getState();
                    ExploreProjectsViewer.this.viewer.setInput(state.getProjects());
                    ExploreProjectsViewer.this.filterJob.cancel();
                    ExploreProjectsViewer.this.filterJob.setOnlyAnalysis(state.isOnlyAnalysis());
                    ExploreProjectsViewer.this.filterJob.schedule(100L);
                }
            }
        });
    }

    private class FilterJob
    extends WorkbenchJob {
        private String filter;
        private boolean onlyAnalysis;

        public FilterJob() {
            super(Messages.getString(ExploreProjectsViewer.class, "filter.job.name"));
            this.filter = null;
            this.onlyAnalysis = true;
            this.setSystem(true);
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public void setOnlyAnalysis(boolean onlyAnalysis) {
            this.onlyAnalysis = onlyAnalysis;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ViewerFilter vf = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    ProjectInfo pi = (ProjectInfo)element;
                    if (FilterJob.this.onlyAnalysis && !pi.getType().isEZ()) {
                        return false;
                    }
                    if (FilterJob.this.filter != null && !FilterJob.this.filter.isEmpty()) {
                        int n;
                        boolean res;
                        boolean bl = res = pi.getName() == null || pi.getName().toLowerCase().indexOf(FilterJob.this.filter.toLowerCase()) != -1 || pi.getType() != null && pi.getType().toString().indexOf(FilterJob.this.filter) != -1 || pi.getDescription() != null && pi.getDescription().indexOf(FilterJob.this.filter) != -1;
                        if (!res && FilterJob.this.filter.contains("#")) {
                            String[] values;
                            String[] stringArray = values = FilterJob.this.filter.split("#");
                            n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String v = stringArray[n2];
                                boolean bl2 = res = pi.getName() != null && pi.getName().toString().equals(v);
                                if (res) break;
                                ++n2;
                            }
                        }
                        if (FilterJob.this.filter.contains(":")) {
                            String[] annotations = pi.getMetadataKeys().split(",");
                            String filterAnn = FilterJob.this.filter.substring(FilterJob.this.filter.lastIndexOf(":") + 1);
                            String[] stringArray = annotations;
                            int n3 = annotations.length;
                            n = 0;
                            while (n < n3) {
                                String ann = stringArray[n];
                                if (ann.trim().equals(filterAnn.trim())) {
                                    res = true;
                                    break;
                                }
                                ++n;
                            }
                        }
                        return res;
                    }
                    return true;
                }
            };
            ExploreProjectsViewer.this.viewer.setFilters(new ViewerFilter[]{vf});
            return Status.OK_STATUS;
        }
    }

    private class ProjectsComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 0;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ProjectInfo p1 = (ProjectInfo)e1;
            ProjectInfo p2 = (ProjectInfo)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.compareTo(p2);
                    break;
                }
                case 1: {
                    rc = p1.getType().toString().compareToIgnoreCase(p2.getType().toString());
                    break;
                }
                case 2: {
                    if (p1.getDescription() != null) {
                        if (p2.getDescription() != null) {
                            rc = p1.getDescription().compareToIgnoreCase(p2.getDescription());
                            break;
                        }
                        rc = 1;
                        break;
                    }
                    rc = -1;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class ProjectsLabelProvider
    implements ITableLabelProvider {
        private ProjectsLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            if (columnIndex == 0 && element != null && element instanceof ProjectInfo) {
                ProjectInfo pi = (ProjectInfo)element;
                img = ExploreProjectsViewer.this.ir.get(pi.getType().toString());
                if (img == null) {
                    ExploreProjectsViewer.this.ir.put(pi.getType().toString(), pi.getDescriptor());
                    img = ExploreProjectsViewer.this.ir.get(pi.getType().toString());
                }
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            if (element != null && element instanceof ProjectInfo) {
                ProjectInfo pi = (ProjectInfo)element;
                switch (columnIndex) {
                    case 0: {
                        text = pi.getName();
                        break;
                    }
                    case 1: {
                        text = pi.getType().getTypeName();
                        break;
                    }
                    case 2: {
                        text = pi.getDescription();
                        break;
                    }
                    case 3: {
                        text = pi.getMetadataKeys();
                    }
                }
            } else {
                text = Messages.getString(ExploreProjectsViewer.class, "wrongData.message");
            }
            return text;
        }
    }
}

