/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.explore.projects;

import com.ez.analysis.base.explore.projects.ExploreProjectsAction;
import com.ez.analysis.base.explore.projects.ExploreProjectsViewer;
import com.ez.analysis.base.explore.projects.State;
import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExploreProjectsDescriptor
extends AbstractActionDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExploreProjectsDescriptor.class);
    private ExploreProjectsAction action = new ExploreProjectsAction(this);
    private ExploreProjectsViewer viewer = new ExploreProjectsViewer(this);
    private State state = new State();
    public static final String EXPLORE_PROJECTS = "com.ez.analysis.base.explore.projects";
    public static final String PROJECT = "com.ez.analysis.base.explore.projects.PROJECT";
    public static final String ROOT = "com.ez.analysis.base.explore.projects.rootpath";

    public IAction getAction() {
        return this.action;
    }

    public IResultViewer getResultViewer() {
        return this.viewer;
    }

    public void loadState(String stateHint) {
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        State state = new State();
        String prjsMarker = "#projects#";
        int idx = stateHint.indexOf(prjsMarker);
        String propPart = null;
        if (idx != -1) {
            propPart = stateHint.substring(0, idx);
        }
        if (propPart != null) {
            Properties prop = new Properties();
            try {
                prop.load(new StringReader(propPart));
            }
            catch (IOException e) {
                L.error("while loading properties: {}", (Object)propPart, (Object)e);
            }
            state.setOnlyAnalysis(Boolean.parseBoolean(prop.getProperty("onlyAnalysis", "true")));
        } else {
            state.setOnlyAnalysis(true);
        }
        List<ProjectInfo> projects = service.getProjects();
        state.setProjects(projects);
        this.setState(state);
    }

    public String persistState() {
        StringBuilder sb = new StringBuilder();
        boolean onlyAnalysis = this.state.isOnlyAnalysis();
        sb.append("onlyAnalysis=").append(onlyAnalysis).append("\n");
        return sb.toString();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        if (this.viewer != null) {
            this.viewer.update();
        }
    }

    public boolean isEmbedded() {
        return true;
    }

    public boolean isSaveStateCandidate() {
        return true;
    }
}

