/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.explore.projects;

import com.ez.analysis.base.explore.projects.ExploreProjectsDescriptor;
import com.ez.analysis.base.explore.projects.State;
import com.ez.analysis.base.internal.Messages;
import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExploreProjectsAction
implements IAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExploreProjectsAction.class);
    private ExploreProjectsDescriptor descriptor;
    private IActionContext icontext = null;

    public ExploreProjectsAction(ExploreProjectsDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setInputContext(IActionContext context) {
        this.icontext = context;
    }

    public boolean canHandle(IActionContext context) {
        return false;
    }

    public IActionContext getOutputContext() {
        return this.descriptor.getState();
    }

    public void execute(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.beginTask(Messages.getString(ExploreProjectsAction.class, "exploreProject.taskName"), 100);
        boolean createState = true;
        boolean refresh = false;
        if (this.icontext != null) {
            Map data = this.icontext.getData();
            if (data != null) {
                Boolean doRefresh = (Boolean)data.get("REFRESH");
                if (doRefresh != null && !doRefresh.booleanValue() && this.icontext instanceof State) {
                    this.descriptor.setState((State)this.icontext);
                    createState = false;
                }
                if (doRefresh != null) {
                    refresh = doRefresh;
                }
            } else {
                refresh = true;
            }
        }
        if (createState && !monitor.isCanceled()) {
            this.createState(refresh, (IProgressMonitor)monitor.newChild(100));
        }
        monitor.done();
    }

    public void createState(boolean doRefresh, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        if (doRefresh) {
            service.refresh((IProgressMonitor)monitor.newChild(90));
        }
        List<ProjectInfo> projects = service.getProjects();
        if (!monitor.isCanceled()) {
            State state = new State();
            if (this.descriptor.getState() != null) {
                state.setOnlyAnalysis(this.descriptor.getState().isOnlyAnalysis());
            }
            state.setProjects(projects);
            this.descriptor.setState(state);
        }
    }
}

