/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.explore.folders;

import com.ez.analysis.base.explore.folders.ExploreFoldersDescriptor;
import com.ez.analysis.base.internal.Messages;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExploreFoldersViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String SINGLEFILE_KEY = "file";
    private ExploreFoldersDescriptor descriptor;
    private Table table;

    public ExploreFoldersViewer(ExploreFoldersDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Composite create(Composite parent, IAction action, final IActionManager manager) {
        Composite c = new Composite(parent, 0);
        final Color fileColor = new Color((Device)c.getDisplay(), 230, 230, 180);
        final Color hiddenColor = new Color((Device)c.getDisplay(), 230, 230, 230);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        this.table = new Table(c, 516);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        Map odata = this.descriptor.getState().getData();
        String pf = null;
        File[] files = null;
        if (odata != null) {
            pf = (String)odata.get("parent");
            files = (File[])odata.get("files");
        }
        String header = Messages.getString(ExploreFoldersViewer.class, "table.column.title");
        if (pf != null) {
            header = pf;
        }
        String[] titles = new String[]{header};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            ++i;
        }
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                TableItem item = new TableItem(this.table, 0);
                String name = f.getName();
                item.setText(0, name.isEmpty() ? f.getAbsolutePath() : name);
                if (!f.isDirectory()) {
                    item.setBackground(fileColor);
                }
                if (f.isHidden()) {
                    item.setBackground(hiddenColor);
                }
                item.setData(SINGLEFILE_KEY, (Object)f);
                ++n2;
            }
            i = 0;
            while (i < titles.length) {
                this.table.getColumn(i).pack();
                ++i;
            }
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem item;
                File f;
                int idx = ExploreFoldersViewer.this.table.getSelectionIndex();
                if (idx != -1 && (f = (File)(item = ExploreFoldersViewer.this.table.getItem(idx)).getData(ExploreFoldersViewer.SINGLEFILE_KEY)).isDirectory()) {
                    manager.launch(ExploreFoldersDescriptor.EXPLORE_FOLDERS, (IActionContext)new AbstractActionContext(){

                        public Map<String, Object> getData() {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("parent", f.getAbsolutePath());
                            return data;
                        }

                        public String getId() {
                            return ExploreFoldersDescriptor.EXPLORE_FOLDERS;
                        }
                    });
                }
            }
        });
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fileColor.dispose();
                hiddenColor.dispose();
            }
        });
        return c;
    }
}

