/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.explore.folders;

import com.ez.analysis.base.explore.folders.ExploreFoldersAction;
import com.ez.analysis.base.explore.folders.ExploreFoldersViewer;
import com.ez.analysis.base.explore.folders.State;
import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IResultViewer;
import java.io.File;

public class ExploreFoldersDescriptor
extends AbstractActionDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ExploreFoldersViewer viewer = new ExploreFoldersViewer(this);
    private ExploreFoldersAction action = new ExploreFoldersAction(this);
    private State state = new State();
    public static String EXPLORE_FOLDERS = "com.ez.analysis.base.explore.folders";

    public IAction getAction() {
        return this.action;
    }

    public IResultViewer getResultViewer() {
        return this.viewer;
    }

    public void loadState(String stateHint) {
        if (stateHint == null) {
            return;
        }
        String parent = null;
        File[] files = null;
        String[] parts = stateHint.split(File.pathSeparator);
        if (parts.length > 0) {
            String string = parent = parts[0].equals("null") ? null : parts[0];
            if (parts.length > 1) {
                files = new File[parts.length - 1];
                int i = 1;
                while (i < parts.length) {
                    files[i - 1] = new File(parts[i]);
                    ++i;
                }
            }
        }
        this.state.setParent(parent);
        this.nameHint(parent);
        this.state.setFiles(files);
    }

    public String persistState() {
        StringBuilder sb = new StringBuilder();
        String parent = this.state.getParent();
        File[] files = this.state.getFiles();
        sb.append(parent);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                sb.append(File.pathSeparator).append(f.getAbsolutePath());
                ++n2;
            }
        }
        return sb.toString();
    }

    public IActionContext getState() {
        return this.state;
    }

    public void nameHint(String parent) {
        if (parent != null) {
            int idx = parent.lastIndexOf(File.separator);
            if (parent.length() == idx + 1) {
                idx = -1;
            }
            String newName = idx == -1 ? parent : parent.substring(idx + 1);
            this.setName(newName);
        }
    }

    public boolean isEmbedded() {
        return true;
    }
}

