/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.explore.folders;

import com.ez.analysis.base.explore.folders.ExploreFoldersDescriptor;
import com.ez.analysis.base.explore.folders.State;
import com.ez.analysis.base.internal.Messages;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExploreFoldersAction
implements IAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ExploreFoldersDescriptor descriptor;

    public ExploreFoldersAction(ExploreFoldersDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean canHandle(IActionContext context) {
        boolean ok = false;
        if (context != null) {
            Map data = context.getData();
            ok = data.get("com.ez.analysis.base.explore.projects.rootpath") != null || data.get("parent") != null;
        }
        return ok;
    }

    public void setInputContext(IActionContext context) {
        Map icontext = context.getData();
        if (icontext == null) {
            return;
        }
        String root = (String)icontext.get("com.ez.analysis.base.explore.projects.rootpath");
        String parent = (String)icontext.get("parent");
        if (parent == null) {
            parent = root;
        }
        this.descriptor.nameHint(parent);
        ((State)this.descriptor.getState()).setParent(parent);
    }

    public IActionContext getOutputContext() {
        return this.descriptor.getState();
    }

    public void execute(IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString(ExploreFoldersAction.class, "exploreFolders.taskName"), -1);
        IActionContext state = this.descriptor.getState();
        Map data = state.getData();
        String parent = (String)data.get("parent");
        File[] files = null;
        if (parent == null) {
            files = File.listRoots();
        } else {
            File f = new File(parent);
            if (f.exists() && f.isDirectory()) {
                files = f.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                });
            }
        }
        ((State)this.descriptor.getState()).setParent(parent);
        ((State)this.descriptor.getState()).setFiles(files);
        monitor.done();
    }
}

