/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base;

import com.ez.analysis.base.project.ProjectProvider;
import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysis.base.projects.service.impl.ProjectsServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final Logger L = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "com.ez.analysis.base";
    private static Activator plugin;
    private List<ProjectProvider> projectProviders;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ProjectsServiceImpl projectsService = new ProjectsServiceImpl();
        context.registerService(IProjectsService.class.getName(), (Object)projectsService, null);
        L.debug("registering service: {}", (Object)IProjectsService.class.getName());
    }

    public void stop(BundleContext context) throws Exception {
        ServiceReference serviceReference = context.getServiceReference(IProjectsService.class.getName());
        if (serviceReference != null) {
            ProjectsServiceImpl cfr_ignored_0 = (ProjectsServiceImpl)context.getService(serviceReference);
            L.debug("unregistering service {}", (Object)IProjectsService.class.getName());
            context.ungetService(serviceReference);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized List<ProjectProvider> getProjectProviders() {
        L.trace("getProjectProviders(): {}", this.projectProviders);
        if (this.projectProviders == null) {
            this.loadProjectProviders();
        }
        return this.projectProviders;
    }

    private void loadProjectProviders() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.analysis.project");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String clsName = config.getAttribute("class");
            Bundle contributorBundle = Platform.getBundle((String)config.getContributor().getName());
            Class instClass = null;
            try {
                instClass = contributorBundle.loadClass(clsName);
            }
            catch (ClassNotFoundException ex) {
                L.error("could not load project provider {}", (Object)clsName, (Object)ex);
            }
            if (instClass != null) {
                try {
                    ProjectProvider pp = (ProjectProvider)instClass.newInstance();
                    if (this.projectProviders == null) {
                        this.projectProviders = new ArrayList<ProjectProvider>();
                    }
                    this.projectProviders.add(pp);
                    L.debug("loaded {}", (Object)pp.getClass().getCanonicalName());
                }
                catch (Exception ex) {
                    L.error("could not instantiate project provider {}", (Object)clsName, (Object)ex);
                }
            }
            ++n2;
        }
    }

    public static ImageRegistry getImgRegistry() {
        if (plugin != null) {
            return plugin.getImageRegistry();
        }
        return null;
    }
}

