/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.utils;

import com.ez.workspace.internal.Messages;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FileUtils.class);
    public static String SEPARATOR = "#EZ#";

    public static Set getAllFiles(IFolder parentFold, Set files) {
        try {
            IResource[] members;
            if (files == null) {
                files = new HashSet<IResource>();
            }
            if ((members = parentFold.members()) != null) {
                int i = 0;
                while (i < members.length) {
                    IResource child = members[i];
                    if (child.getType() == 1) {
                        files.add(child);
                    } else {
                        FileUtils.getAllFiles((IFolder)child, files);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            WorkspaceLogUtil.err(Messages.getString(FileUtils.class, "getResourceChildrens.error", new String[]{parentFold.toString()}), e);
        }
        return files;
    }

    public static Set getAllFilesWithRequiredExtension(IFolder parentFold, Set files, String extension) {
        try {
            if (files == null) {
                files = new HashSet<IResource>();
            }
            if (parentFold.members() != null) {
                int i = 0;
                while (i < parentFold.members().length) {
                    IResource child = parentFold.members()[i];
                    if (child.getType() == 1) {
                        if (child.getFileExtension().equalsIgnoreCase(extension)) {
                            files.add(child);
                        }
                    } else {
                        FileUtils.getAllFilesWithRequiredExtension((IFolder)child, files, extension);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            WorkspaceLogUtil.err(Messages.getString(FileUtils.class, "getResourceChildrens.error", new String[]{parentFold.toString()}), e);
        }
        return files;
    }

    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static File zipIt(File source) throws IOException {
        File zipFile = null;
        ArrayList<File> fileList = new ArrayList<File>();
        FileUtils.getAllFiles(source, fileList);
        zipFile = FileUtils.writeZipFile(source, fileList);
        return zipFile;
    }

    public static void getAllFiles(File dir, List<File> fileList) {
        try {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                fileList.add(file);
                if (file.isDirectory()) {
                    L.debug("directory: {}", (Object)file.getCanonicalPath());
                    FileUtils.getAllFiles(file, fileList);
                } else {
                    L.debug("     file: {}", (Object)file.getCanonicalPath());
                }
                ++n2;
            }
        }
        catch (IOException e) {
            L.trace("", (Throwable)e);
        }
    }

    public static File writeZipFile(File directoryToZip, List<File> fileList) throws IOException {
        File zipFile = File.createTempFile("impact", "zip");
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                FileUtils.addToZip(directoryToZip, file, zos);
            }
        }
        finally {
            if (zos != null) {
                zos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return zipFile;
    }

    public static void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        L.debug("Writing '{}' to zip file", (Object)zipFilePath);
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    public static boolean unZipIt(String zipFile, String outputFolder) {
        boolean ok;
        block20: {
            byte[] buffer = new byte[1024];
            ZipInputStream zis = null;
            ok = true;
            try {
                try {
                    File folder = new File(outputFolder);
                    if (!folder.exists()) {
                        folder.mkdirs();
                    }
                    zis = new ZipInputStream(new FileInputStream(zipFile));
                    ZipEntry ze = null;
                    while ((ze = zis.getNextEntry()) != null) {
                        String fileName = ze.getName();
                        File newFile = new File(outputFolder, fileName);
                        L.debug("file unzip : {}", (Object)newFile.getAbsoluteFile());
                        new File(newFile.getParent()).mkdirs();
                        FileOutputStream fos = null;
                        try {
                            try {
                                int len;
                                fos = new FileOutputStream(newFile);
                                while ((len = zis.read(buffer)) > 0) {
                                    fos.write(buffer, 0, len);
                                }
                            }
                            catch (Exception e) {
                                L.error("could not unzip entry {}", (Object)newFile, (Object)e);
                                ok = false;
                                fos.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            fos.close();
                            throw throwable;
                        }
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    L.error("could not unzip file {}", (Object)zipFile, (Object)ex);
                    ok = false;
                    if (zis == null) break block20;
                    try {
                        zis.closeEntry();
                        zis.close();
                    }
                    catch (IOException e) {
                        L.error("could not close stream", (Throwable)e);
                    }
                }
            }
            finally {
                if (zis != null) {
                    try {
                        zis.closeEntry();
                        zis.close();
                    }
                    catch (IOException e) {
                        L.error("could not close stream", (Throwable)e);
                    }
                }
            }
        }
        return ok;
    }

    public static void deleteFolder(File folder) {
        if (folder != null && folder.exists()) {
            File[] files;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            folder.delete();
        }
    }
}

