/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.utils;

import com.ez.internal.utils.Utils;
import com.ez.workspace.internal.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataStore {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FileDataStore.class);
    private static final String FILE_DIR = Utils.getApplicationDefaultPath();
    private static final String PREFIX_SEPARATOR = "<P*>";
    private static final String DEFAULT_PREFIX = "default_prefix";
    private final Set<String> prefixSet = new HashSet<String>();
    private String filePath;
    private File file;
    private Properties properties;
    private String comments = Messages.getString(FileDataStore.class, "exportedFile.comment");
    public static final Map<String, FileDataStore> DATA_STORE_MAP = new HashMap<String, FileDataStore>();

    public static synchronized FileDataStore getDataStore(String relativePath) {
        return FileDataStore.getDataStore(relativePath, true);
    }

    public static synchronized FileDataStore getDataStore(String path, boolean isRelativePath) {
        FileDataStore dataStore;
        if (DATA_STORE_MAP.containsKey(path)) {
            dataStore = DATA_STORE_MAP.get(path);
        } else {
            dataStore = new FileDataStore(path, isRelativePath);
            DATA_STORE_MAP.put(path, dataStore);
        }
        return dataStore;
    }

    private FileDataStore(String path, boolean isRelativePath) {
        this.filePath = isRelativePath ? String.valueOf(FILE_DIR) + File.separator + path : path;
        this.file = new File(this.filePath);
        this.load();
    }

    public synchronized String getProperty(String propertyName) {
        return this.getProperty(DEFAULT_PREFIX, propertyName);
    }

    public synchronized String getProperty(String prefix, String propertyName) {
        return this.properties.getProperty(String.valueOf(prefix) + "." + PREFIX_SEPARATOR + "." + propertyName);
    }

    public synchronized Properties getProperties(String prefix) {
        prefix = String.valueOf(prefix) + ".<P*>.";
        Properties properties = new Properties();
        Enumeration<?> enumerator = this.properties.propertyNames();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = this.properties.getProperty(key);
            key = key.substring(prefix.length());
            properties.setProperty(key, value);
        }
        return properties;
    }

    public synchronized void setProperty(String propertyName, String property) {
        this.setProperty(DEFAULT_PREFIX, propertyName, property);
    }

    public synchronized void setProperty(String prefix, String propertyName, String property) {
        this.prefixSet.add(prefix);
        if (property == null) {
            this.properties.remove(String.valueOf(prefix) + "." + PREFIX_SEPARATOR + "." + propertyName);
            this.updatePrefixList();
        }
        this.properties.setProperty(String.valueOf(prefix) + "." + PREFIX_SEPARATOR + "." + propertyName, property);
        this.save();
    }

    public synchronized void setProperties(Properties properties, String prefix) {
        String key;
        this.prefixSet.add(prefix);
        prefix = String.valueOf(prefix) + ".<P*>.";
        Enumeration<?> enumerator = this.properties.propertyNames();
        while (enumerator.hasMoreElements()) {
            key = (String)enumerator.nextElement();
            if (!key.startsWith(prefix)) continue;
            this.properties.remove(key);
        }
        enumerator = properties.propertyNames();
        while (enumerator.hasMoreElements()) {
            key = (String)enumerator.nextElement();
            String value = properties.getProperty(key);
            key = String.valueOf(prefix) + key;
            this.properties.setProperty(key, value);
        }
        if (properties.isEmpty()) {
            this.updatePrefixList();
        }
        this.save();
    }

    private void save() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        new File(FileDataStore.this.file.getParent()).mkdirs();
                        try (FileWriter fileWriter = new FileWriter(FileDataStore.this.file);){
                            FileDataStore.this.properties.store(fileWriter, String.valueOf(FileDataStore.this.comments) + ":");
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        L.error("File {} does not exist.", (Object)FileDataStore.this.file);
                    }
                    catch (IOException e) {
                        L.error("IOException.", (Throwable)e);
                    }
                }
            }
        }).start();
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    private synchronized void load() {
        this.properties = new Properties();
        try (FileReader fileReader = new FileReader(this.file);){
            this.properties.load(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            L.error("File {} does not exist.", (Object)this.file);
        }
        catch (IOException e) {
            L.error("IOException.", (Throwable)e);
        }
        this.updatePrefixList();
    }

    private synchronized void updatePrefixList() {
        this.prefixSet.clear();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            int index;
            String s = (String)e.nextElement();
            if (s == null || (index = s.indexOf(PREFIX_SEPARATOR)) < 0) continue;
            s = s.substring(0, s.indexOf(PREFIX_SEPARATOR) - 1);
            this.prefixSet.add(s);
        }
    }

    public Set<String> getPrefixSet() {
        return this.prefixSet;
    }

    public void removeProperties(String filterPropertiesKey, String secondKey) {
        Enumeration<?> enumerator = this.properties.propertyNames();
        filterPropertiesKey = String.valueOf(filterPropertiesKey) + ".<P*>." + secondKey;
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            if (!key.startsWith(filterPropertiesKey)) continue;
            this.properties.remove(key);
        }
        this.save();
    }
}

