/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.utils;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.internal.utils.ServiceUtils;
import com.ez.workspace.mu.client.ClientAdapter;
import com.ibm.ad.audit.client.AuditClient;
import com.ibm.ad.audit.client.exception.AuditClientInitializeException;
import com.ibm.ad.audit.client.exception.AuditClientNotInitializedException;
import com.ibm.ad.audit.client.exception.AuditException;
import com.ibm.audit.model.pojo.EventPOJO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditUtils {
    private static final Logger L = LoggerFactory.getLogger(AuditUtils.class);
    public static final int CLIENT_APP_ID = 3;
    private static String auditServiceProtocol;
    private static String auditServiceHostname;
    private static int auditServicePort;
    private static final long interval = 120000L;
    private static long endTime;

    static {
        auditServicePort = Integer.valueOf("9080");
        endTime = 0L;
    }

    public static void initalizeAuditServiceConnection() {
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.error("no pref service available for now");
        } else {
            try {
                auditServiceProtocol = srv.getString("general.webservice.audit", "audit.protocol", "http", null);
                auditServiceHostname = srv.getString("general.webservice.audit", "audit.host", "localhost", null);
                auditServicePort = Integer.valueOf(srv.getString("general.webservice.audit", "audit.port", "9080", null));
                L.info("Audit setup: audit protocol = {}, audit host = {}, audit port = {}", new Object[]{auditServiceProtocol, auditServiceHostname, auditServicePort});
                AuditClient.initialize((String)auditServiceProtocol, (String)auditServiceHostname, (int)auditServicePort);
                AuditClient.setApplicationId((Integer)3);
                L.info("audit service was initialized successfully");
                endTime = System.currentTimeMillis() + 120000L;
            }
            catch (AuditClientInitializeException iniEx) {
                L.warn("audit service initialization failed ", (Throwable)iniEx);
            }
        }
    }

    public static EventPOJO createAuditEvent(int operationCode, String operationName, String projectName) {
        EventPOJO event = new EventPOJO();
        event.setIp(ClientAdapter.getClient().getIP());
        event.setOperationTypeId(Integer.valueOf(operationCode));
        event.setOperationName(operationName);
        event.setUserName(System.getProperty("user.name"));
        event.setProjectName(projectName);
        event.setInstanceId(ClientAdapter.getClient().getInstanceId());
        return event;
    }

    public static void auditAnalysisEvent(EventPOJO analysisEvent) {
        try {
            AuditClient.audit((EventPOJO)analysisEvent);
        }
        catch (AuditClientNotInitializedException notIniEx) {
            L.warn(notIniEx.getMessage(), (Throwable)notIniEx);
        }
        catch (AuditException audite) {
            L.warn(audite.getMessage(), (Throwable)audite);
        }
    }
}

