/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.state;

import com.ez.workspace.state.AEvent;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.IEZStateListener;
import com.ez.workspace.state.IStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StateManager
implements IStateManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static StateManager inst;
    private Map listenersGroupByEventType = null;

    private StateManager() {
    }

    public static synchronized StateManager getInstance() {
        if (inst == null) {
            inst = new StateManager();
        }
        return inst;
    }

    @Override
    public void register(IEZStateListener ezStateListener, EventType evType) {
        if (this.listenersGroupByEventType == null) {
            this.listenersGroupByEventType = new HashMap();
        }
        ArrayList<IEZStateListener> existentListeners = null;
        if (this.listenersGroupByEventType.containsKey(evType)) {
            existentListeners = (ArrayList)this.listenersGroupByEventType.get(evType);
            this.listenersGroupByEventType.remove(existentListeners);
        }
        if (existentListeners == null) {
            existentListeners = new ArrayList<IEZStateListener>();
        }
        existentListeners.add(ezStateListener);
        this.listenersGroupByEventType.put(evType, existentListeners);
    }

    @Override
    public void unregister(IEZStateListener ezStateListener, EventType evType) {
        ArrayList existentListener;
        if (this.listenersGroupByEventType != null && this.listenersGroupByEventType.containsKey(evType) && (existentListener = (ArrayList)this.listenersGroupByEventType.get(evType)) != null && existentListener.contains(ezStateListener)) {
            existentListener.remove(ezStateListener);
        }
    }

    @Override
    public void notify(AEvent event) {
        List listenerList;
        EventType evType = event.getEvType();
        if (this.listenersGroupByEventType != null && this.listenersGroupByEventType.size() > 0 && (listenerList = (List)this.listenersGroupByEventType.get(evType)) != null && listenerList.size() > 0) {
            Iterator it = listenerList.iterator();
            while (it.hasNext()) {
                ((IEZStateListener)it.next()).notify(event);
            }
        }
    }
}

