/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences;

import com.ez.workspace.Activator;
import com.ez.workspace.preferences.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreferenceUtils.class);

    public static final Object getDefaultValue(String preference) {
        if (preference != null) {
            if (preference.equalsIgnoreCase("levelsZoomPreference")) {
                return PreferenceUtils.getLevelZoom();
            }
            if (preference.equalsIgnoreCase("verboseLogPreference")) {
                return PreferenceUtils.getDefaultVerboseLog();
            }
            if (preference.equalsIgnoreCase("enableEasyLogPreference")) {
                return PreferenceConstants.EASY_LOG_CONFIG;
            }
            if (preference.equalsIgnoreCase("additionalSVGforVisio")) {
                return PreferenceUtils.getDefaultGenSVGCopyVisio();
            }
            if (preference.equalsIgnoreCase("indirectLinksPreference")) {
                return PreferenceUtils.getDefaultDisplayIndirectLinks();
            }
            if (preference.equalsIgnoreCase("graphNodesExceed")) {
                return PreferenceUtils.getDefaultGraphExceedLimit();
            }
            if (preference.equalsIgnoreCase("callgraphLevelsLimitedPreference")) {
                return PreferenceConstants.DEF_CALLGRAPH_LEVELS_LIMITED;
            }
            if (preference.equalsIgnoreCase("callgraphLimitExceed")) {
                return PreferenceConstants.DEF_CALLGRAPH_LEVELS_LIMIT;
            }
            if (preference.equalsIgnoreCase("graphHighlightedOnlyExpandableAtLimit")) {
                return PreferenceConstants.DEF_GRAPH_HIGHLIGHT_AT_LIMIT;
            }
            if (preference.equalsIgnoreCase("callgraphRestrictedNodesVisibility")) {
                return PreferenceConstants.DEF_CALLGRAPH_NODES_VISIBILITY_RESTRICTION;
            }
            if (preference.equalsIgnoreCase("callgraphWithoutResources")) {
                return PreferenceConstants.DEF_GRAPH_WITHOUT_RESOURCES;
            }
            if (preference.equalsIgnoreCase("showCgOtherPrj")) {
                return PreferenceConstants.CG_OTHER_PRJ;
            }
        }
        L.warn("null default value for preference: {}", (Object)preference);
        return null;
    }

    private static Object getDefaultVerboseLog() {
        return PreferenceConstants.VERBOSE_LOG;
    }

    private static Boolean getDefaultGenSVGCopyVisio() {
        return PreferenceConstants.GENERATE_SVG_COPY_VISIO;
    }

    private static String getLevelZoom() {
        return "2";
    }

    private static Boolean getDefaultDisplayIndirectLinks() {
        return PreferenceConstants.DEF_INDIRECT_LINKS;
    }

    private static final Integer getDefaultGraphExceedLimit() {
        return PreferenceConstants.GRAPH_EXCEED_LIMIT;
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        Activator default1 = Activator.getDefault();
        if (default1 != null) {
            IPreferenceStore store = default1.getPreferenceStore();
            store.addPropertyChangeListener(listener);
        }
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        Activator default1 = Activator.getDefault();
        if (default1 != null) {
            IPreferenceStore store = default1.getPreferenceStore();
            store.removePropertyChangeListener(listener);
        }
    }
}

