/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client.commands;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.mu.client.commands.ProjectCommand;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProjectCommand
extends ProjectCommand {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DeleteProjectCommand.class);
    private List<String> paths;
    private boolean deleteContents = true;

    public DeleteProjectCommand(String serverHost, int serverPort, Client client, String prjName) {
        super(serverHost, serverPort, client, prjName, AnalysisType.DELETE_PROJECT);
    }

    public void setDeleteContents(boolean deleteContents) {
        this.deleteContents = deleteContents;
    }

    @Override
    public void execute() {
        this.input.clear();
        this.input.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_PROJECT_NAME, this.prjName);
        this.input.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_RESOURCE_PATH, this.paths);
        this.input.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_DELETE_PROJECT_CONTENTS, this.deleteContents);
        super.execute();
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }
}

