/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client.commands;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.model.EZProjectInfo;
import com.ez.workspace.mu.client.commands.ProjectCommand;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.EnumMap;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateSharedPrjCommand
extends ProjectCommand {
    private static final Logger L = LoggerFactory.getLogger(CreateSharedPrjCommand.class);
    protected EZProjectInfo info;
    protected boolean hasUpdateRights = false;
    protected Properties dbProperties;
    protected Object otherProperties;

    protected CreateSharedPrjCommand(String serverHost, Client client, int rmiRegPort, String prjName) {
        super(serverHost, rmiRegPort, client, prjName, AnalysisType.CREATE_PROJECT);
    }

    public CreateSharedPrjCommand(String serverHost, Client client, int rmiRegPort, String prjName, EZProjectInfo info, boolean isLocal) {
        this(serverHost, client, rmiRegPort, prjName);
        this.isLocal = isLocal;
        this.info = info;
    }

    @Override
    public void execute() {
        if (this.result != null) {
            this.result.clear();
        }
        if (this.isLocal) {
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ACTIVE);
        } else {
            EnumMap<RequestConstants.AnalysisRequestKeys, Object> analysis = new EnumMap<RequestConstants.AnalysisRequestKeys, Object>(RequestConstants.AnalysisRequestKeys.class);
            analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_CLIENT_ID, (Object)this.client);
            analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_REQUEST_TYPE, (Object)AnalysisType.CREATE_PROJECT.getOperationCode());
            analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_PROJECT_NAME, (Object)this.prjName);
            analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_PROJECT_DB_SETTINGS, (Object)this.dbProperties);
            try {
                this.result = this.requestAnalysis(analysis);
                L.info("server response: {}", (Object)this.result);
            }
            catch (Exception e) {
                L.error("Client exception:", (Throwable)e);
                this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ERROR);
                this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE, e);
            }
        }
    }

    public abstract IProject createLocalProject(IProgressMonitor var1) throws AccessException, RemoteException, NotBoundException, CoreException;

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean hasUpdateRights() {
        return this.hasUpdateRights;
    }

    public void setUpdateRights(boolean hasUpdateRights) {
        this.hasUpdateRights = hasUpdateRights;
    }

    public void setDbProperties(Properties dbProperties) {
        this.dbProperties = dbProperties;
    }

    public void setOtherProperties(Object otherProperties) {
        this.otherProperties = otherProperties;
    }

    public abstract Integer getPrjType();

    public Properties getDBProperties() {
        return this.dbProperties;
    }
}

