/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client.commands;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestAnalysisInterface;
import com.ez.mu.itf.RequestConstants;
import com.ez.mu.utils.ServerUtils;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command {
    private static final Logger L = LoggerFactory.getLogger(Command.class);
    protected String serverHost;
    protected int serverPort;
    protected Client client = null;
    protected EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> result = new EnumMap(RequestConstants.AnalysisRequestReturnKeys.class);
    protected EnumMap<RequestConstants.AnalysisRequestKeys, Object> input = new EnumMap(RequestConstants.AnalysisRequestKeys.class);

    public Command(String serverHost, int serverPort, Client client) {
        this.serverHost = serverHost;
        this.client = client;
        this.serverPort = serverPort;
    }

    public abstract void execute();

    public EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> getResult() {
        return this.result;
    }

    protected RequestAnalysisInterface getStub() throws RemoteException, NotBoundException, AccessException {
        RequestAnalysisInterface stub = ServerUtils.getStub((String)this.serverHost, (int)this.serverPort, (String)"SharedProject");
        return stub;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Client getClient() {
        return this.client;
    }

    public String getServerWorkspace(boolean shouldCheckLicense, EnumMap<RequestConstants.AnalysisRequestKeys, Object> licensingInfoEnumMap) throws RemoteException, NotBoundException, AccessException {
        String wksp = null;
        Map serverWorkspaceInfoMap = this.getStub().getServerWorkspace(shouldCheckLicense, licensingInfoEnumMap);
        if (shouldCheckLicense) {
            Integer licenseStatus = (Integer)serverWorkspaceInfoMap.get("license status key");
            switch (licenseStatus) {
                case 1: {
                    if (serverWorkspaceInfoMap.get("server workspace key") != null) {
                        wksp = (String)serverWorkspaceInfoMap.get("server workspace key");
                        break;
                    }
                    L.warn("workspace received from server is null");
                    break;
                }
                case 0: {
                    L.warn("Failed to obtain workspace from server. Client is not licensed!");
                    break;
                }
                case -1: {
                    L.warn("Failed to obtain workspace from server. Client license validation failed!");
                    break;
                }
                case -2: {
                    L.warn("Probably wrong client ip configuration. Client license validation failed!");
                    break;
                }
            }
        } else if (serverWorkspaceInfoMap.get("server workspace key") != null) {
            wksp = (String)serverWorkspaceInfoMap.get("server workspace key");
        } else {
            L.warn("workspace received from server is null");
        }
        return wksp;
    }

    public void addInput(RequestConstants.AnalysisRequestKeys inputKey, Object value) {
        if (inputKey != null && value != null) {
            this.input.put(inputKey, value);
        } else {
            L.warn("inputKey or value are NULL");
        }
    }

    public EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> requestAnalysis(EnumMap<RequestConstants.AnalysisRequestKeys, Object> analysis) throws RemoteException, NotBoundException, AccessException {
        Integer operationCode = (Integer)analysis.get(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_REQUEST_TYPE);
        AnalysisType analysisType = AnalysisType.fromOpCode((Integer)operationCode);
        L.debug("requestAnalysis  - request type: {}", (Object)analysisType);
        return this.getStub().requestAnalysis(false, analysis);
    }
}

