/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client.commands;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.mu.client.commands.ProjectCommand;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseSharedCommand
extends ProjectCommand {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CloseSharedCommand.class);

    public CloseSharedCommand(String serverHost, int serverPort, Client client, String prjName) {
        super(serverHost, serverPort, client, prjName, AnalysisType.CLOSE_PROJECT);
    }

    @Override
    public void execute() {
        if (this.result != null) {
            this.result.clear();
        }
        EnumMap<RequestConstants.AnalysisRequestKeys, Object> analysis = new EnumMap<RequestConstants.AnalysisRequestKeys, Object>(RequestConstants.AnalysisRequestKeys.class);
        analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_CLIENT_ID, (Object)this.client);
        analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_REQUEST_TYPE, (Object)AnalysisType.CLOSE_PROJECT.getOperationCode());
        analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_PROJECT_NAME, (Object)this.prjName);
        try {
            this.result = this.requestAnalysis(analysis);
            L.info("server response: {}", (Object)this.result);
        }
        catch (Exception e) {
            L.error("Client exception:", (Throwable)e);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ERROR);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE, e);
        }
    }
}

