/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client.commands;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.mu.client.commands.Command;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelledCommand
extends Command {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CancelledCommand.class);
    protected Integer commandId;
    private AnalysisType forType;

    public CancelledCommand(String serverHost, int serverPort, Client client, Integer requestId, AnalysisType forType) {
        super(serverHost, serverPort, client);
        this.commandId = requestId;
        this.forType = forType;
    }

    @Override
    public void execute() {
        EnumMap<RequestConstants.AnalysisRequestKeys, Object> analysis = new EnumMap<RequestConstants.AnalysisRequestKeys, Object>(RequestConstants.AnalysisRequestKeys.class);
        analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_CLIENT_ID, (Object)this.client);
        analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_REQUEST_ID, (Object)this.commandId);
        analysis.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_REQUEST_TYPE, (Object)AnalysisType.REQUEST_CANCELLED.getOperationCode());
        try {
            this.result = this.requestAnalysis(analysis);
        }
        catch (AccessException e) {
            L.error("Client exception", (Throwable)e);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ERROR);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE, e);
        }
        catch (RemoteException e) {
            L.error("Client exception", (Throwable)e);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ERROR);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE, e);
        }
        catch (NotBoundException e) {
            L.error("Client exception", (Throwable)e);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ERROR);
            this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE, e);
        }
        L.debug("cancell command result: {}", (Object)this.result);
    }
}

