/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client.commands;

import com.ez.internal.analysis.AnalysisType;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.mu.client.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAnalysisCommand
extends Command {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractAnalysisCommand.class);
    protected AnalysisType type;

    public AbstractAnalysisCommand(String serverHost, int serverPort, Client client, AnalysisType type) {
        super(serverHost, serverPort, client);
        this.type = type;
    }

    @Override
    public void execute() {
        block3: {
            this.input.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_CLIENT_ID, this.client);
            this.input.put(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_REQUEST_TYPE, this.type.getOperationCode());
            if (this.result != null) {
                this.result.clear();
            }
            try {
                this.result = this.requestAnalysis(this.input);
                RequestConstants.RequestStatus status = (RequestConstants.RequestStatus)this.result.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS);
                L.info("server response status: {}", (Object)status);
                L.debug("server response: {}", (Object)this.result);
            }
            catch (Exception e) {
                L.error("error execute abstract command", (Throwable)e);
                if (this.result == null) break block3;
                this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, RequestConstants.RequestStatus.STATUS_ERROR);
                this.result.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE, e);
            }
        }
    }
}

