/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.service.ConfigurationService;
import com.ez.eclient.configuration.service.DefaultConfigurationService;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mu.itf.RequestAnalysisInterface;
import com.ez.mu.utils.ServerUtils;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZProjectIDSg;
import java.math.BigDecimal;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);

    public static QualifiedName buildServerIDPropertyName(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", projectName.concat("_serverIP"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildServerPortPropertyName(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", projectName.concat("_serverPort"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectSharedPropertyName(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", projectName.concat("_isShared"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildProjectInstantiator(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", projectName.concat("_instantiator"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static String getProjectInstantiator(IProject project) {
        QualifiedName qName = Utils.buildProjectInstantiator(project.getName());
        String prjInstantiator = "";
        try {
            prjInstantiator = project.getPersistentProperty(qName);
        }
        catch (CoreException e) {
            L.error("getProjectInstantiator() for {}", (Object)project.getName(), (Object)e);
        }
        return prjInstantiator;
    }

    public static boolean isProjectShared(IProject project) {
        QualifiedName qName = Utils.buildProjectSharedPropertyName(project.getName());
        String shared = null;
        try {
            shared = project.getPersistentProperty(qName);
            if (shared == null) {
                qName = new QualifiedName("EZSource4SAPClient", project.getName().concat("_isShared"));
                shared = project.getPersistentProperty(qName);
            }
        }
        catch (CoreException e) {
            L.error("isProjectShared() for {}", (Object)project.getName(), (Object)e);
        }
        return shared != null && Boolean.valueOf(shared) != false;
    }

    public static RequestAnalysisInterface getStub(String serverHost, int port, String remoteRef) throws RemoteException, NotBoundException, AccessException {
        RequestAnalysisInterface stub = ServerUtils.getStub((String)serverHost, (int)port, (String)remoteRef);
        return stub;
    }

    public static QualifiedName buildProjectSidPropertyName(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", projectName.concat("_sid"));
        L.trace("name: {}", (Object)qName);
        return qName;
    }

    public static boolean readyToAnalyse(List selList) {
        boolean canUseAnalyse = true;
        IProject proj = null;
        String oldBoolVal = "";
        String oldIPVal = "";
        for (Object obj : selList) {
            if (!(obj instanceof IResource)) continue;
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                proj = file.getProject();
            } else if (obj instanceof IProject) {
                proj = (IProject)obj;
            } else if (obj instanceof IFolder) {
                IFolder folder = (IFolder)obj;
                proj = folder.getProject();
            }
            String projName = proj.getName();
            QualifiedName qName = Utils.buildProjectSharedPropertyName(projName);
            try {
                String notLocal = proj.getPersistentProperty(qName);
                if (notLocal == null) {
                    notLocal = String.valueOf(Utils.isProjectShared(proj));
                }
                if ("".equals(oldBoolVal)) {
                    oldBoolVal = notLocal;
                } else if (oldBoolVal != null && oldBoolVal.equals(notLocal)) {
                    canUseAnalyse = true;
                } else {
                    canUseAnalyse = false;
                    break;
                }
                boolean val = Boolean.parseBoolean(notLocal);
                if (!val) continue;
                qName = Utils.buildServerIDPropertyName(projName);
                String serverIP = proj.getPersistentProperty(qName);
                if ("".equals(oldIPVal)) {
                    oldIPVal = serverIP;
                    continue;
                }
                if (oldIPVal.equals(serverIP)) {
                    canUseAnalyse = true;
                    continue;
                }
                canUseAnalyse = false;
                break;
            }
            catch (CoreException e) {
                L.error("readyToAnalyse()", (Throwable)e);
                canUseAnalyse = false;
            }
        }
        return canUseAnalyse;
    }

    public static boolean readyToAnalyseOneProj(List selList) {
        boolean canUseAnalyse = true;
        IProject proj = null;
        String oldPrjNameVal = "";
        for (Object obj : selList) {
            if (!(obj instanceof IResource)) continue;
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                proj = file.getProject();
            } else if (obj instanceof IProject) {
                proj = (IProject)obj;
            } else if (obj instanceof IFolder) {
                IFolder folder = (IFolder)obj;
                proj = folder.getProject();
            }
            String projName = proj.getName();
            if ("".equals(oldPrjNameVal)) {
                oldPrjNameVal = projName;
                continue;
            }
            if (oldPrjNameVal != null && oldPrjNameVal.equals(projName)) {
                canUseAnalyse = true;
                continue;
            }
            canUseAnalyse = false;
            break;
        }
        return canUseAnalyse;
    }

    public static boolean scopeShared(List inputs) {
        EZEntityID entityId = null;
        boolean isShared = true;
        if (inputs != null) {
            for (Object obj : inputs) {
                if (obj instanceof EZEntityID) {
                    entityId = (EZEntityID)obj;
                } else if (obj instanceof EZObjectType) {
                    EZObjectType objType = (EZObjectType)obj;
                    entityId = objType.getEntID();
                }
                if (entityId != null) {
                    EZProjectIDSg projectIDSg = (EZProjectIDSg)entityId.getSegment(EZProjectIDSg.class);
                    EZProject ezProject = projectIDSg.getEzProject();
                    IProject proj = ezProject.getProject();
                    boolean shared = Utils.isProjectShared(proj);
                    if (shared) continue;
                    isShared = false;
                    break;
                }
                L.warn("entityID null for input object: {}", obj);
            }
        }
        return isShared;
    }

    public static QualifiedName buildOwnerPropertyName(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", projectName.concat("_isOwner"));
        L.debug("name: {}", (Object)qName);
        return qName;
    }

    public static QualifiedName buildUpdateRithgsPropertyName(String projectName) {
        QualifiedName qName = new QualifiedName("com.ez.workspace", "hasUpdateRights");
        L.debug("name: {}", (Object)qName);
        return qName;
    }

    public static boolean isOwner(IProject project) {
        QualifiedName ownerProperty = Utils.buildOwnerPropertyName(project.getName());
        String owner = null;
        boolean ret = false;
        try {
            owner = project.getPersistentProperty(ownerProperty);
            ret = owner == null ? false : Boolean.valueOf(owner);
        }
        catch (CoreException e) {
            L.error("isOwner() for {}", (Object)project.getName(), (Object)e);
        }
        return ret;
    }

    public static boolean hasUpdateRights(IProject project) {
        QualifiedName ownerProperty = Utils.buildUpdateRithgsPropertyName(project.getName());
        String updateRights = null;
        boolean ret = false;
        try {
            updateRights = project.getPersistentProperty(ownerProperty);
            ret = updateRights == null ? false : Boolean.valueOf(updateRights);
        }
        catch (CoreException e) {
            L.error("hasUpdateRights() for {}", (Object)project.getName(), (Object)e);
        }
        return ret;
    }

    public static void setUpdateRightsAllSharedProjects(boolean hasUpdateRights) {
        EZProject[] allProjects = EZWorkspace.getInstance().getProjects();
        int i = 0;
        while (i < allProjects.length) {
            IProject project;
            EZProject ezProject = allProjects[i];
            if (ezProject != null && ezProject.getProject() != null && Utils.isProjectShared(project = ezProject.getProject())) {
                QualifiedName qName = Utils.buildUpdateRithgsPropertyName(project.getName());
                try {
                    project.setPersistentProperty(qName, Boolean.toString(hasUpdateRights));
                }
                catch (CoreException e) {
                    L.error("cannot write persistent property as update mark rights", (Throwable)e);
                }
            }
            ++i;
        }
    }

    public static Integer getServerPort(String serverHost) {
        Map<String, Integer> srvs = Utils.getServersFromPreferences(null);
        return srvs.get(serverHost);
    }

    public static Map<String, Integer> getServerPorts() {
        return Utils.getServersFromPreferences(null);
    }

    private static Map<String, Integer> getServersFromPreferences(String scope) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        List<Map<String, Object>> res = Utils.readServersFromPreferences(scope);
        if (res != null) {
            for (Map<String, Object> map : res) {
                String host = (String)map.get("host");
                BigDecimal port = (BigDecimal)map.get("port");
                try {
                    ret.put(host, Integer.valueOf(port.toString()));
                }
                catch (NumberFormatException e) {
                    L.error("wrong port number! server {} it will be ignored", (Object)host, (Object)e);
                }
            }
        } else {
            L.info("there are no configured servers");
        }
        return ret;
    }

    public static List<Map<String, Object>> readServersFromPreferences(String scope) {
        List ret = null;
        try {
            Configuration conf = null;
            conf = scope == null ? ((DefaultConfigurationService)ConfigurationService.getDefault()).getConfiguration("general.networking.eclipse_servers") : ((DefaultConfigurationService)ConfigurationService.getDefault()).getConfiguration("general.networking.eclipse_servers", scope);
            if (conf != null) {
                ret = (List)conf.getObject("servers");
            } else {
                L.info("there are no shared servers configured");
            }
        }
        catch (Exception ex) {
            L.error("error reading servers", (Throwable)ex);
        }
        return ret;
    }

    public static String getDefaultServerHost() {
        String ret = null;
        List<Map<String, Object>> srv = Utils.readServersFromPreferences(null);
        if (srv != null && !srv.isEmpty()) {
            for (Map<String, Object> map : srv) {
                Boolean def = Utils.isServerDefault(map);
                if (!def.booleanValue()) continue;
                ret = (String)map.get("host");
                break;
            }
        }
        return ret != null ? ret : "";
    }

    public static int getDefaultServerPort() {
        Integer ret = null;
        List<Map<String, Object>> srv = Utils.readServersFromPreferences(null);
        if (srv != null && !srv.isEmpty()) {
            for (Map<String, Object> map : srv) {
                Boolean def = Utils.isServerDefault(map);
                if (!def.booleanValue()) continue;
                try {
                    ret = Integer.valueOf(map.get("port").toString());
                    break;
                }
                catch (NumberFormatException e) {
                    L.warn("wrong port number! server {} it will be ignored", map.get("host"), (Object)e);
                }
            }
        }
        return ret != null ? ret : 1099;
    }

    public static Boolean isServerDefault(Map<String, Object> serverProps) {
        Object o;
        Boolean ret = Boolean.FALSE;
        if (serverProps != null && (o = serverProps.get("isDefault")) != null) {
            if (o instanceof Boolean) {
                ret = (Boolean)o;
            } else if (o instanceof String) {
                ret = Boolean.valueOf((String)o);
            }
        }
        return ret;
    }
}

