/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client;

import com.ez.internal.utils.Pair;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestAnalysisInterface;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.mu.client.ClientAdapter;
import com.ez.workspace.mu.client.Utils;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAliveThread
extends Thread {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ClientAliveThread.class);
    int CLIENT_TIMEOUT = 30000;
    private Client client;
    protected Map<String, Set<IProject>> servers;
    protected Map<String, Integer> serversPort;
    private boolean running;
    protected Map<String, Set<IProject>> toRemove = new HashMap<String, Set<IProject>>();
    protected List<Pair<String, Integer>> serversToAdd = Collections.synchronizedList(new LinkedList());
    protected Set<IProject> toAdd = new HashSet<IProject>();
    protected Map<String, Set<Object>> serversToNotif = new HashMap<String, Set<Object>>();

    public ClientAliveThread(Client client) {
        this.client = client;
        L.debug("new ClientAliveThread()");
        this.setName("ClientAliveThread");
    }

    protected void notifyServers() {
        this.servers = new HashMap<String, Set<IProject>>();
        this.serversPort = new HashMap<String, Integer>();
    }

    @Override
    public void run() {
        L.debug("ClientAliveThread running");
        this.notifyServers();
        this.running = true;
        L.debug("ClientAliveThread will notify servers: {}", this.servers);
        while (this.running) {
            if (this.servers != null) {
                String serverHost2 = null;
                ArrayList<String> deadServers = new ArrayList<String>();
                for (String serverHost2 : this.servers.keySet()) {
                    try {
                        L.debug("client is alive. notify server: {}", (Object)serverHost2);
                        int port = this.serversPort.get(serverHost2);
                        RequestAnalysisInterface stub = Utils.getStub(serverHost2, port, "SharedProject");
                        stub.isAlive(((ClientAdapter)this.client).getClientStub());
                    }
                    catch (Exception e) {
                        L.error("error at server's ALIVE notification", (Throwable)e);
                        if (serverHost2 == null || this.servers.get(serverHost2) == null) continue;
                        deadServers.add(serverHost2);
                    }
                }
                for (String sHost : deadServers) {
                    Set<IProject> prjs = this.servers.get(sHost);
                    if (prjs != null && prjs.size() != 0) {
                        final String msg = Messages.getString(ClientAliveThread.class, "information.message", new String[]{sHost});
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                                Shell shell = window.getShell();
                                MessageDialog.openInformation((Shell)shell, (String)Messages.getString(ClientAliveThread.class, "information.title"), (String)msg);
                            }
                        });
                        for (IProject project : prjs) {
                            try {
                                project.close((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                L.error("error at closing project: {}", (Object)project, (Object)e);
                            }
                        }
                    }
                    this.servers.remove(sHost);
                    this.serversPort.remove(sHost);
                }
            }
            try {
                L.debug("ClientAliveThread will sleep now");
                ClientAliveThread.sleep(this.CLIENT_TIMEOUT);
                L.debug("ClientAliveThread awake");
                this.manageModif();
            }
            catch (InterruptedException e) {
                L.error("", (Throwable)e);
            }
        }
        this.servers = null;
        L.debug("end ClientAliveThread running");
    }

    protected long manageModif() {
        long time = System.currentTimeMillis();
        L.debug("add additional servers: {}", this.serversToAdd);
        while (this.serversToAdd.size() > 0) {
            Pair<String, Integer> serverInfo = this.serversToAdd.remove(0);
            String sHost = (String)serverInfo.getFirst();
            int sPort = (Integer)serverInfo.getSecond();
            this.serversPort.put(sHost, sPort);
            Set<IProject> serverPrjs = this.servers.get(sHost);
            if (serverPrjs != null) continue;
            serverPrjs = new HashSet<IProject>();
            this.servers.put(sHost, serverPrjs);
        }
        L.debug("remove projects: {}", this.toRemove.values());
        for (String sHost : this.toRemove.keySet()) {
            if (sHost == null) continue;
            Set<IProject> removed = this.toRemove.get(sHost);
            this.servers.get(sHost).removeAll(removed);
            if (!this.servers.get(sHost).isEmpty()) continue;
            this.servers.remove(sHost);
            this.serversPort.remove(sHost);
        }
        this.toRemove.clear();
        L.debug("registered projects={}", this.servers);
        time = System.currentTimeMillis() - time;
        L.debug("delayed with: {} miliseconds", (Object)time);
        return time;
    }

    public void stopThread() {
        this.running = false;
        L.info("I'm dying! notification sent to servers: {}", this.servers);
        if (this.servers != null) {
            for (String serverHost : this.servers.keySet()) {
                try {
                    int port = this.serversPort.get(serverHost);
                    RequestAnalysisInterface stub = Utils.getStub(serverHost, port, "SharedProject");
                    stub.isDead(((ClientAdapter)this.client).getClientStub());
                }
                catch (AccessException e) {
                    L.error("error at 'dead' notification", (Throwable)e);
                }
                catch (RemoteException e) {
                    L.error("error at 'dead' notification", (Throwable)e);
                }
                catch (NotBoundException e) {
                    L.error("error at 'dead' notification", (Throwable)e);
                }
            }
        }
    }

    public void register(String serverHost, int serverPort) {
        this.serversToAdd.add((Pair<String, Integer>)new Pair((Object)serverHost, (Object)serverPort));
    }

    public void register(IProject prj) {
        this.toAdd.add(prj);
    }

    public void unregister(IProject prj, String serverHost) {
        boolean notAdded = this.toAdd.remove(prj);
        if (!notAdded) {
            Set<IProject> serverPrjs = this.toRemove.get(serverHost);
            if (serverPrjs == null) {
                serverPrjs = new HashSet<IProject>();
                this.toRemove.put(serverHost, serverPrjs);
            }
            serverPrjs.add(prj);
        }
    }

    public void doCheck() {
    }

    public void register(Pair<String, Object> analysisPair) {
        String serverIP = (String)analysisPair.getFirst();
        Object analysisID = analysisPair.getSecond();
        Set<Object> ans = this.serversToNotif.get(serverIP);
        if (ans == null) {
            ans = new HashSet<Object>();
            this.serversToNotif.put(serverIP, ans);
        }
        ans.add(analysisID);
    }

    public void unregister(Pair<String, Object> analysisPair) {
        String serverIP = (String)analysisPair.getFirst();
        Object analysis = analysisPair.getSecond();
        Set<Object> ans = this.serversToNotif.get(serverIP);
        if (ans == null || ans.isEmpty()) {
            L.warn("no custom analysis on server: {}", (Object)serverIP);
        } else {
            boolean vb = ans.remove(analysis);
            L.debug("custom analysis {} was removed={} from server {}", new Object[]{analysis, vb, serverIP});
            if (ans.isEmpty()) {
                L.debug("server {} will not be notified", (Object)serverIP);
                this.serversToNotif.remove(serverIP);
                this.servers.remove(serverIP);
            }
        }
    }
}

