/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.mu.client;

import com.ez.internal.utils.Pair;
import com.ez.internal.utils.PathUtils;
import com.ez.internal.utils.PreferenceConstants;
import com.ez.internal.utils.PreferencesUtils;
import com.ez.mu.itf.Client;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAdapter
implements Client {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ClientAdapter.class);
    private static final String ADAPTERS_EXTENSION_POINT = "com.ez.workspace.client.adapter";
    private static final long serialVersionUID = 1L;
    private String IP;
    private String wksp;
    private String minimServerVersion;
    private String clientStringVersion;
    private String sid;
    private String instanceId;
    private static ClientAdapter INSTANCE;
    private boolean alive = false;
    private int callbackPort;
    private Client clientStub;
    private Map<Integer, AbstractSharedAnalysis> pendingRequests = new HashMap<Integer, AbstractSharedAnalysis>();
    private Map<Integer, Client.NotificationType> pendingNotFound = new HashMap<Integer, Client.NotificationType>();
    NotificationProcessor process;
    Object waitObj = new Object();

    ClientAdapter(String IP, String workspace) {
        this(IP, workspace, false);
    }

    protected ClientAdapter(String IP, String workspace, boolean usePreferences) {
        this.IP = IP;
        this.wksp = workspace;
        this.sid = UUID.randomUUID().toString();
        this.instanceId = UUID.nameUUIDFromBytes(workspace.getBytes()).toString();
        if (usePreferences) {
            Properties install = PathUtils.getInstallProperties();
            this.minimServerVersion = install.getProperty("ADAnalyzeServer.minim.version");
            this.clientStringVersion = install.getProperty("version");
            if (this.minimServerVersion == null || this.clientStringVersion == null) {
                L.error("---minimServerVersion {}", (Object)this.minimServerVersion);
                L.error("---clientStringVersion {}", (Object)this.clientStringVersion);
            }
            L.trace("client: {}", (Object)this.hashCode());
        }
        this.process = new NotificationProcessor();
        this.process.setName(Messages.getString(ClientAdapter.class, "notificationProcess.name"));
        this.callbackPort = usePreferences ? PreferenceConstants.getInternalCallbackPort() : 0;
    }

    public String getClientVersion() {
        return this.clientStringVersion;
    }

    public String getServerMinimVersion() {
        return this.minimServerVersion;
    }

    public static ClientAdapter getClient(String ip, String workspacePath, boolean usePreferences) {
        if (INSTANCE == null) {
            System.setProperty("java.rmi.server.hostname", ip);
            INSTANCE = ClientAdapter.instantiateAdapter(workspacePath, ip, usePreferences);
            INSTANCE.startCallbackService();
            ClientAdapter.INSTANCE.process.start();
            L.debug("processThread: {}", (Object)ClientAdapter.INSTANCE.process.isAlive());
        }
        return INSTANCE;
    }

    public static ClientAdapter getClient() {
        String ip = PreferencesUtils.manageClientIP();
        L.debug("using client ip: {}", (Object)ip);
        String wksp = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        return ClientAdapter.getClient(ip, wksp, true);
    }

    private static ClientAdapter instantiateAdapter(String wksp, String ip, boolean usePreferences) {
        ClientAdapter adapter = null;
        L.debug("loading adapters");
        if (usePreferences) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(ADAPTERS_EXTENSION_POINT);
            if (point == null) {
                L.error("{} was not properly registered", (Object)ADAPTERS_EXTENSION_POINT);
            } else {
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension ext = extensions[i];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    if (configElements != null) {
                        int j = 0;
                        while (j < configElements.length) {
                            IContributor contributor = configElements[j].getContributor();
                            Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
                            Class instClass = null;
                            String clazz = configElements[j].getAttribute("class");
                            try {
                                instClass = contributorBundle.loadClass(clazz);
                            }
                            catch (ClassNotFoundException ex) {
                                L.error("could not load {}", (Object)clazz, (Object)ex);
                            }
                            if (instClass != null) {
                                try {
                                    Constructor ctor = instClass.getDeclaredConstructor(String.class, String.class);
                                    adapter = (ClientAdapter)ctor.newInstance(ip, wksp);
                                }
                                catch (Exception e) {
                                    L.error("could not instantiate {}", (Object)clazz, (Object)e);
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        if (adapter == null) {
            adapter = new ClientAdapter(ip, wksp, usePreferences);
        }
        return adapter;
    }

    public String getIP() {
        return this.IP;
    }

    public String getWorkspace() {
        return this.wksp;
    }

    public int getPort() {
        return this.callbackPort;
    }

    public String getSID() {
        return this.sid;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.IP == null ? 0 : this.IP.hashCode());
        result = 31 * result + (this.wksp == null ? 0 : this.wksp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientAdapter other = (ClientAdapter)obj;
        if (this.IP == null ? other.IP != null : !this.IP.equals(other.IP)) {
            return false;
        }
        return !(this.wksp == null ? other.wksp != null : !this.wksp.equals(other.wksp));
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.IP);
        buff.append(" -- ");
        buff.append(this.wksp);
        return buff.toString();
    }

    public void addPending(Integer id, AbstractSharedAnalysis analysis) {
        if (this.pendingNotFound.containsKey(id)) {
            L.debug("request {} is in pendingNotFound", (Object)id);
        } else {
            this.pendingRequests.put(id, analysis);
            L.debug("{} :::addPending {}", (Object)this, (Object)id);
        }
    }

    public void managePendingNotFound(Integer id, AbstractSharedAnalysis analysis) {
        Client.NotificationType type = this.pendingNotFound.remove(id);
        if (type != null) {
            L.debug("pending not found for id={}", (Object)id);
            analysis.releaseWaitObj(type, id);
        }
    }

    public void removeRequest(Integer id) {
        this.pendingRequests.remove(id);
        L.debug("{} :::removePending {}", (Object)this, this.pendingRequests);
    }

    public void startCallbackService() {
        try {
            this.clientStub = (Client)UnicastRemoteObject.exportObject((Remote)((Object)INSTANCE), this.callbackPort);
            this.alive = true;
            L.info("client adapter server ready");
        }
        catch (Exception e) {
            L.error("start callback server error", (Throwable)e);
            WorkspaceLogUtil.err(Messages.getString(ClientAdapter.class, "logview.error.message"), e);
        }
    }

    public void stopCallbackService() throws RemoteException {
        try {
            if (this.alive) {
                UnicastRemoteObject.unexportObject((Remote)((Object)INSTANCE), true);
                this.alive = false;
                L.info("client adapter server stoped");
            } else {
                L.info("client adapter server already stoped");
            }
        }
        catch (RemoteException e) {
            L.error("stopCallbackServer()", (Throwable)e);
        }
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notification(Client.NotificationType type, Object param) throws RemoteException {
        Object object = this.waitObj;
        synchronized (object) {
            this.process.addNotification(type, param);
            L.debug("client notified about {}", (Object)type);
            this.waitObj.notifyAll();
        }
    }

    public void process(Client.NotificationType type, Object id) {
        if (id instanceof Integer && (type.equals((Object)Client.NotificationType.REQUEST_EXECUTED) || type.equals((Object)Client.NotificationType.REQUEST_DENIED))) {
            L.debug("#################### {} notifType={}", id, (Object)type);
            AbstractSharedAnalysis an = this.pendingRequests.remove(id);
            L.debug("analysis: {}", (Object)an);
            L.debug("{} ::all: {}", (Object)this, this.pendingRequests);
            if (an != null) {
                an.releaseWaitObj(type, (Integer)id);
            } else {
                this.pendingNotFound.put((Integer)id, type);
            }
        } else {
            this.processSpecificNotification(type, id);
        }
    }

    protected void processSpecificNotification(Client.NotificationType type, Object id) {
    }

    public Client getClientStub() {
        return this.clientStub;
    }

    protected void showMessage(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                Shell shell = window.getShell();
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString(ClientAdapter.class, "information.dialog.title"), (String)msg);
            }
        });
    }

    class NotificationProcessor
    extends Thread {
        List<Pair<Client.NotificationType, Object>> notifications = new ArrayList<Pair<Client.NotificationType, Object>>();

        NotificationProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (INSTANCE != null) {
                L.debug("before wait");
                Object object = ClientAdapter.this.waitObj;
                synchronized (object) {
                    try {
                        ClientAdapter.this.waitObj.wait();
                    }
                    catch (InterruptedException e) {
                        L.error("", (Throwable)e);
                        break;
                    }
                }
                L.debug("after wait");
                while (!this.notifications.isEmpty()) {
                    ArrayList<Pair<Client.NotificationType, Object>> copy = new ArrayList<Pair<Client.NotificationType, Object>>(this.notifications);
                    for (Pair pair : copy) {
                        Client.NotificationType type = (Client.NotificationType)pair.getFirst();
                        Object notifParam = pair.getSecond();
                        ClientAdapter.this.process(type, notifParam);
                        this.notifications.remove(pair);
                    }
                }
                L.debug("after process");
            }
        }

        void addNotification(Client.NotificationType type, Object notifParam) {
            this.notifications.add((Pair<Client.NotificationType, Object>)new Pair((Object)type, notifParam));
        }
    }
}

