/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model.segments;

import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceResourceIDSg;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZSourceScreenIDSg
extends EZSourceResourceIDSg {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZSourceScreenIDSg.class);
    private int screenType;
    private String mapSet;
    private Integer occurID;
    private Integer mapID;
    private String odbRID;
    private boolean hasLayout;
    Set<EZSourceProgramIDSg> programs = new HashSet<EZSourceProgramIDSg>();
    public static final String BMS_SCREEN_TYPE = "bms screen type";
    public static final String ADS_SCREEN_TYPE = "ads screen type";
    public static final String NATURAL_SCREEN_TYPE = "natural screen type";

    public EZSourceScreenIDSg(Integer mapID, String scrName, int scrType, Integer occurID) {
        super(scrName);
        this.mapID = mapID;
        this.screenType = scrType;
        this.occurID = occurID;
        this.hasLayout = occurID != null && occurID > 0 && scrName != null;
    }

    public EZSourceScreenIDSg(String scrName, String scrMapSet, Integer mapID, int scrType, String odbRID) {
        super(scrName);
        this.mapSet = scrMapSet;
        this.screenType = scrType;
        this.odbRID = odbRID;
        this.mapID = mapID;
    }

    public void addProgram(EZSourceProgramIDSg prgSg) {
        this.programs.add(prgSg);
    }

    public Set<EZSourceProgramIDSg> getPrograms() {
        return this.programs;
    }

    public int getScreenType() {
        return this.screenType;
    }

    public String getScreenName() {
        return this.name;
    }

    public void setMapSet(String mapSet) {
        this.mapSet = mapSet;
    }

    public String getMapSet() {
        return this.mapSet;
    }

    public Integer getOccurID() {
        return this.occurID;
    }

    public Integer getMapID() {
        return this.mapID;
    }

    public void setHasLayout(boolean hasLayout) {
        this.hasLayout = hasLayout;
    }

    public boolean hasLayout() {
        return this.hasLayout;
    }

    public String getScreenNameToPrint() {
        String ret = this.name;
        String mapSetName = this.getMapSet();
        L.debug("screen type: {}", (Object)this.screenType);
        if (mapSetName != null && !mapSetName.isEmpty() && !mapSetName.equalsIgnoreCase("VT_NULL")) {
            L.debug("mapSetName: {}", (Object)mapSetName);
            ret = mapSetName.concat("-").concat(this.name);
        }
        return ret;
    }

    @Override
    public boolean isOfType(Class type) {
        if (type.equals(EZSourceScreenIDSg.class)) {
            return true;
        }
        return super.isOfType(type);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof EZSourceScreenIDSg && this.number == ((EZSourceScreenIDSg)((Object)obj)).number && this.name.equals(((EZSourceScreenIDSg)((Object)obj)).name) && this.screenType == ((EZSourceScreenIDSg)((Object)obj)).screenType) {
            if (this.mapID == null || ((EZSourceScreenIDSg)((Object)obj)).mapID == null) {
                String mapSet2 = ((EZSourceScreenIDSg)((Object)obj)).mapSet;
                return this.mapSet == null && mapSet2 == null || this.mapSet != null && this.mapSet.equals(mapSet2);
            }
            return this.mapID.intValue() == ((EZSourceScreenIDSg)((Object)obj)).mapID.intValue();
        }
        return false;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == EZSourceScreenIDSg.class) {
            return this;
        }
        return null;
    }
}

