/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.workspace.state.AnnotationEvent;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.StateManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    public static final String PROJECT_PROPERTY_CONTRIBUTOR = "ezresource.contributor";
    public static final String SELECTION_PROPERTY_CONTRIBUTOR = "ezselection.contributor";
    public static final String ACTION_PROPERTY = "action";
    public static final String DB_STMTS_4TSNODE_ATTRIBUTE = "DB_STMTS_4TSNODE";

    public static boolean mustBuild(IResourceDelta delta) {
        boolean continueBuild = false;
        IResourceDelta d = delta;
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        if (affectedChildren != null && affectedChildren.length > 0) {
            int i = 0;
            while (i < affectedChildren.length) {
                continueBuild = Utils.mustBuild(affectedChildren[i]);
                if (!continueBuild) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            continueBuild = Utils.shouldBuild(d);
        }
        return continueBuild;
    }

    public static boolean shouldBuild(IResourceDelta d) {
        boolean rez = false;
        L.debug("change kind={}", (Object)d.getKind());
        int flags = d.getFlags();
        IResource affected = d.getResource();
        IPath relPath = affected.getProjectRelativePath();
        String seg0 = relPath.segment(0);
        if (seg0 != null && seg0.startsWith(".") || affected.getType() == 1 && affected.getName().equalsIgnoreCase(".prop")) {
            L.debug("build ignored for resource: {}", (Object)affected);
        } else if ((flags & 0x100) != 0) {
            L.debug("content changed for {} flags: {}", (Object)affected, (Object)flags);
            rez = true;
        } else if ((flags & 0x100000) != 0) {
            L.debug("encoding changed for {}", (Object)affected);
        } else {
            L.debug("marked for build {} flags: {}", (Object)affected, (Object)flags);
            rez = true;
        }
        return rez;
    }

    public static String removeExtension(String filename) {
        return com.ez.internal.utils.Utils.removeExtension((String)filename);
    }

    public static IPath removeExtension(IPath path) {
        String extension = path.getFileExtension();
        if (extension != null) {
            path = path.removeFileExtension();
        }
        return path;
    }

    public static void writeModel(Object prg, File fileOut) {
        try {
            FileOutputStream fos = null;
            FileLock fileLock = null;
            ObjectOutputStream os = null;
            try {
                try {
                    fos = new FileOutputStream(fileOut);
                    FileChannel fileChannel = fos.getChannel();
                    fileLock = fileChannel.tryLock();
                    if (fileLock != null) {
                        L.debug("{} locked by me", (Object)fileOut);
                        os = new ObjectOutputStream(new BufferedOutputStream(fos));
                        os.writeObject(prg);
                        os.flush();
                    } else {
                        L.warn("{} is locked by other process", (Object)fileOut);
                    }
                }
                catch (IOException e) {
                    L.error("writeModel() in file {}", (Object)fileOut, (Object)e);
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Throwable ex) {
                    block18: {
                        L.error("exception at writing file {}", (Object)fileOut, (Object)ex);
                        if (fos != null) {
                            fos.close();
                            fileOut.delete();
                        }
                        if (fileLock == null) break block18;
                        fileLock.release();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            finally {
                if (fileLock != null) {
                    fileLock.release();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (IOException ex) {
            L.error("IOException at writing of object {} in file {}", new Object[]{prg, fileOut, ex});
        }
    }

    public static void fireEventAfterClean(IProject project) {
        AnnotationEvent event = new AnnotationEvent();
        event.setEvType(EventType.ANNOTATION_EVENT_TYPE);
        event.setProjectFromClean((IResource)project);
        StateManager.getInstance().notify(event);
    }

    public static ProjectSavePermission verifyServerPermission(IResource resource) {
        ProjectSavePermission ret = ProjectSavePermission.PROJECT_WITH_SAVE_ACTION;
        IProject prj = resource.getProject();
        if (prj.isOpen()) {
            boolean isOwner;
            boolean shared = com.ez.workspace.mu.client.Utils.isProjectShared(prj);
            if (shared && !(isOwner = com.ez.workspace.mu.client.Utils.isOwner(prj))) {
                ret = ProjectSavePermission.PROJECT_NOT_OWNER;
            }
        } else {
            ret = ProjectSavePermission.PROJECT_CLOSED;
        }
        return ret;
    }

    public static boolean addBuilder(IProject project, String builderID) {
        boolean result = false;
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean foundBuilder = false;
            int i = 0;
            while (i < commands.length) {
                ICommand iCommand = commands[i];
                if (iCommand.getBuilderName().equals(builderID)) {
                    foundBuilder = true;
                }
                ++i;
            }
            if (!foundBuilder) {
                Utils.addCommand(desc, builderID);
                project.setDescription(desc, 3, (IProgressMonitor)new NullProgressMonitor());
                result = true;
            } else {
                L.info("builder {} was already added to project {}", (Object)builderID, (Object)project.getName());
            }
        }
        catch (Exception ex) {
            L.error("error adding builder: {} at project: {}", new Object[]{builderID, project.getName(), ex});
        }
        return result;
    }

    public static void addCommand(IProjectDescription desc, String builderID) {
        ICommand[] commands = desc.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName(builderID);
        newCommands[newCommands.length - 1] = command;
        commands = newCommands;
        desc.setBuildSpec(newCommands);
    }

    public static boolean removeBuilder(IProject project, String builderID) {
        boolean result = false;
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(builderID)) {
                    ICommand[] newCommands = new ICommand[commands.length - 1];
                    System.arraycopy(commands, 0, newCommands, 0, i);
                    System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                    description.setBuildSpec(newCommands);
                    project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                    result = true;
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            L.error("error removing builder: {} from project: {}", new Object[]{builderID, project.getName(), ex});
        }
        return result;
    }

    public static enum ProjectSavePermission {
        PROJECT_WITH_SAVE_ACTION,
        PROJECT_CLOSED,
        PROJECT_NOT_OWNER;

    }
}

