/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.internal.id.EZEntityID;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyRegistry {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProxyRegistry.class);
    private static final int PROXIES_SIZE = 100;
    protected Map proxiesMap = Collections.synchronizedMap(new HashMap());

    public void put(IPath programPath, EZEntityID id) {
        this.clear();
        this.proxiesMap.put(programPath, id);
    }

    public EZEntityID get(IPath programPath) {
        EZEntityID ret = null;
        ret = (EZEntityID)this.proxiesMap.get(programPath);
        return ret;
    }

    public EZEntityID remove(IPath programPath) {
        EZEntityID ret = null;
        ret = (EZEntityID)this.proxiesMap.remove(programPath);
        return ret;
    }

    private void clear() {
        if (this.proxiesMap.size() > 100) {
            this.proxiesMap.clear();
            L.debug("clear map");
        }
    }

    public String toString() {
        return this.proxiesMap.toString();
    }
}

