/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.model.EZProxy;
import com.ez.internal.model.EZProxyIDSg;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.model.segments.EZProjectIDSg;
import java.util.Collection;
import org.eclipse.core.resources.IResource;

public class InputResourceFilter
implements EZInputFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean ret = true;
        for (EZObjectType inputType : inputs) {
            EZEntityID entID = inputType.getEntID();
            ret = this.checkID(entID);
            if (!ret) break;
        }
        return ret;
    }

    protected boolean checkID(EZEntityID entID) {
        boolean ret = true;
        if (entID == null) {
            ret = false;
        } else {
            EZProjectIDSg projSG = (EZProjectIDSg)entID.getSegment(EZProjectIDSg.class);
            if (projSG == null) {
                ret = false;
            } else {
                EZProxyIDSg proxySG = (EZProxyIDSg)entID.getSegment(EZProxyIDSg.class);
                if (proxySG == null) {
                    ret = false;
                } else {
                    EZProxy proxy = proxySG.getProxy();
                    if (proxy == null) {
                        ret = false;
                    } else {
                        IResource res = proxy.getResource();
                        if (res == null) {
                            ret = false;
                        }
                    }
                }
            }
        }
        return ret;
    }
}

