/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.mu.client.Utils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZWorkspaceSaveParticipant
implements ISaveParticipant {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZWorkspaceSaveParticipant.class);

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        int kind = context.getKind();
        String eventKind = "";
        switch (kind) {
            case 1: {
                eventKind = "FULL_SAVE";
                L.debug("full save!!!");
                EZProject[] prjs = EZWorkspace.getInstance().getProjects();
                if (prjs == null) break;
                int i = 0;
                while (i < prjs.length) {
                    EZProject proj = prjs[i];
                    IProject iProj = proj.getProject();
                    this.doSave(iProj, proj, eventKind);
                    ++i;
                }
                break;
            }
            case 2: {
                eventKind = "SNAPSHOT";
            }
            case 3: {
                EZProject proj;
                eventKind = "".equals(eventKind) ? "PROJECT_SAVE" : eventKind;
                L.debug("saving type={}", (Object)eventKind);
                IProject iProj = context.getProject();
                if (iProj == null || (proj = EZWorkspace.getInstance().getPrjModel((IResource)iProj)) == null) break;
                this.doSave(iProj, proj, eventKind);
            }
        }
        context.needDelta();
    }

    private void doSave(IProject iProj, EZProject proj, String eventKind) {
        boolean save;
        boolean bl = save = !Utils.isProjectShared(iProj) || Utils.isOwner(iProj);
        if (save) {
            proj.saveInfo(false);
        } else {
            L.debug("not save model for project: {}; client is not owner (it was a {} event)", (Object)iProj.getName(), (Object)eventKind);
        }
    }
}

