/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.internal.analysis.config.context.IgnoreContext;
import com.ez.internal.analysis.config.inputs.AnalysisInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Utils;
import com.ez.protection.Registry;
import com.ez.workspace.Activator;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.gotosource.IGoToSourceService;
import com.ez.workspace.init.Initializer;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.model.Category;
import com.ez.workspace.model.CategoryEntry;
import com.ez.workspace.model.CategoryManager;
import com.ez.workspace.model.EZAnalysisJobListener;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZProjectInstantiator;
import com.ez.workspace.model.segments.EZProjectIDSg;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZWorkspace
implements IAdaptable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZWorkspace.class);
    private static EZWorkspace inst;
    private static final String ACTIONS_EXTENSION_POINT = "com.ez.workspace.analysis";
    private static final String VIEW_SOURCE_EXTENSION_POINT = "com.ez.workspace.viewsource";
    private static final String PROJECT_EXTENSION_POINT = "com.ez.workspace.project";
    private static final String INITIALIZERS_EXTENSION_POINT = "com.ez.workspace.init";
    private static final String ANALYSIS_CATEGORY_EXTENSION_POINT = "com.ez.workspace.analysis.category";
    private static final String ANALYSIS_ATTR_NAME = "name";
    private static final String ANALYSIS_ATTR_CLAZZ = "class";
    private static final String ANALYSIS_ATTR_ID = "id";
    private static final String ANALYSIS_ELEMENT_INPUT = "input";
    private static final String ANALYSIS_INPUT_ATTR_CLAZZ = "class";
    private static final String ANALYSIS_INPUT_ATTR_CONTEXT = "context";
    private static final String ANALYSIS_INPUT_ATTR_AVAILABILITY = "availability";
    private static final String ANALYSIS_INPUT_ATTR_EQUALS = "equals";
    private static final String ANALYSIS_ATTR_ICON = "icon";
    private static final String ANALYSIS_INPUT_FILTER_CLAZZ = "filter";
    private static final String ANALYSIS_ATTR_VARIANT = "variant";
    private static final String ANALYSIS_ATTR_CATEGORY = "category";
    private static final String ANALYSIS_ATTR_HASSETTINGS = "hasSettings";
    private static final String ANALYSIS_ATTR_VIEWID = "viewID";
    private Map<String, EZEntityID> projectsMap = Collections.synchronizedMap(new HashMap());
    private List<EZAnalysisType> analysisTypes = new ArrayList<EZAnalysisType>();
    private CategoryManager categoryManager = new CategoryManager();
    private Map<String, Class<EZProjectInstantiator>> prjInstantiators = new HashMap<String, Class<EZProjectInstantiator>>();
    private Map<EZEntityID, Map<Class<? extends Job>, Set<GraphTranslateJob>>> jobs = new HashMap<EZEntityID, Map<Class<? extends Job>, Set<GraphTranslateJob>>>();
    private Map<String, Class> viewSourceContributors = new HashMap<String, Class>();

    private EZWorkspace() {
    }

    private void loadProjectInstantiators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PROJECT_EXTENSION_POINT);
        if (point == null) {
            L.error("{} was not properly registered", (Object)PROJECT_EXTENSION_POINT);
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            if (configElements != null) {
                int j = 0;
                while (j < configElements.length) {
                    IContributor contributor = configElements[j].getContributor();
                    Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
                    Class instClass = null;
                    try {
                        instClass = contributorBundle.loadClass(configElements[j].getAttribute("instantiator"));
                    }
                    catch (ClassNotFoundException ex) {
                        L.error("Error:", (Throwable)ex);
                    }
                    String natureName = configElements[j].getAttribute("natureid");
                    this.prjInstantiators.put(natureName, instClass);
                    ++j;
                }
            }
            ++i;
        }
    }

    public static synchronized EZWorkspace getInstance() {
        if (inst == null) {
            inst = new EZWorkspace();
            inst.loadInitializers();
            inst.loadProjectInstantiators();
            inst.loadCategories();
            inst.loadAnalysis();
            inst.loadViewSourceContributors();
            EZAnalysisJobListener jl = new EZAnalysisJobListener();
            Job.getJobManager().addJobChangeListener((IJobChangeListener)jl);
            IProject[] prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < prjs.length) {
                EZProjectInstantiator instantiator;
                IProject prj = prjs[i];
                if (prj.isOpen() && (instantiator = inst.getInstantiator(prj)) != null) {
                    inst.registerProject((IResource)prj, true, instantiator);
                }
                ++i;
            }
        }
        return inst;
    }

    private void loadViewSourceContributors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(VIEW_SOURCE_EXTENSION_POINT);
        if (point == null) {
            WorkspaceLogUtil.err(Messages.getString(EZWorkspace.class, "notRegistered.log", new String[]{VIEW_SOURCE_EXTENSION_POINT}), null);
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            if (configElements != null) {
                L.debug("ViewSourceContributors number {}", (Object)configElements.length);
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    String classViewSourceContributor = element.getAttribute("class");
                    String id = element.getAttribute(ANALYSIS_ATTR_ID);
                    element.getAttribute(ANALYSIS_ATTR_NAME);
                    IContributor contributor = element.getContributor();
                    Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
                    Class instClass = null;
                    try {
                        instClass = contributorBundle.loadClass(classViewSourceContributor);
                        this.registerViewSourceContributorClass(id, instClass);
                    }
                    catch (ClassNotFoundException ex) {
                        L.error("could not load class {} : {} ", (Object)classViewSourceContributor, (Object)ex);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void registerViewSourceContributorClass(String id, Class srv) {
        this.viewSourceContributors.put(id, srv);
    }

    public Collection<IGoToSourceService> getViewSourceContributors() {
        HashSet<IGoToSourceService> contrSet = new HashSet<IGoToSourceService>();
        for (Class c : this.viewSourceContributors.values()) {
            try {
                IGoToSourceService srv = (IGoToSourceService)c.newInstance();
                contrSet.add(srv);
            }
            catch (IllegalAccessException | InstantiationException e) {
                L.error("could not instantiate class {} : {} ", (Object)c, (Object)e);
            }
        }
        return contrSet.isEmpty() ? null : contrSet;
    }

    private void loadInitializers() {
        L.debug("loading initializers");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(INITIALIZERS_EXTENSION_POINT);
        if (point == null) {
            L.error("{} was not properly registered", (Object)INITIALIZERS_EXTENSION_POINT);
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            if (configElements != null) {
                int j = 0;
                while (j < configElements.length) {
                    IContributor contributor = configElements[j].getContributor();
                    Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
                    Class instClass = null;
                    String clazz = configElements[j].getAttribute("class");
                    try {
                        instClass = contributorBundle.loadClass(clazz);
                    }
                    catch (ClassNotFoundException ex) {
                        L.error("could not load {}", (Object)clazz, (Object)ex);
                    }
                    if (instClass != null) {
                        Initializer init = null;
                        try {
                            init = (Initializer)instClass.newInstance();
                        }
                        catch (Exception e) {
                            L.error("could not instatiate {}", (Object)clazz, (Object)e);
                        }
                        if (init != null) {
                            try {
                                init.run();
                            }
                            catch (Throwable t) {
                                L.error("while running initializer {}", (Object)clazz, (Object)t);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public EZProjectInstantiator getInstantiator(IProject prj) {
        EZProjectInstantiator instantiator = null;
        try {
            String instantiatorClsName = com.ez.workspace.mu.client.Utils.getProjectInstantiator(prj);
            boolean mustVerifyName = false;
            if (instantiatorClsName != null && !instantiatorClsName.equals("")) {
                mustVerifyName = true;
            }
            Class<EZProjectInstantiator> instantiatorCls = null;
            IProjectDescription description = prj.getDescription();
            String[] natures = description.getNatureIds();
            int i = natures.length - 1;
            while (i >= 0) {
                if (this.prjInstantiators.containsKey(natures[i])) {
                    instantiatorCls = this.prjInstantiators.get(natures[i]);
                    if (!mustVerifyName || instantiatorClsName.equals(instantiatorCls.getName())) break;
                }
                --i;
            }
            if (instantiatorCls != null) {
                instantiator = (EZProjectInstantiator)instantiatorCls.newInstance();
            }
        }
        catch (Exception e) {
            L.error("could not get an instantiator", (Throwable)e);
        }
        if (instantiator == null) {
            L.warn("{} project does not have EZ* nature!", (Object)prj);
        }
        return instantiator;
    }

    public EZProject[] getProjects() {
        EZProject[] projs = null;
        if (!this.projectsMap.isEmpty()) {
            EZEntityID[] ids = this.projectsMap.values().toArray(new EZEntityID[0]);
            projs = new EZProject[ids.length];
            EZEntityID id = null;
            int i = 0;
            while (i < ids.length) {
                id = ids[i];
                EZProjectIDSg sg = (EZProjectIDSg)id.getSegment(EZProjectIDSg.class);
                projs[i] = sg.getEzProject();
                ++i;
            }
        }
        return projs;
    }

    public EZProjectIDSg[] getProjectIDs() {
        EZProjectIDSg[] projs = null;
        if (!this.projectsMap.isEmpty()) {
            EZEntityID[] ids = this.projectsMap.values().toArray(new EZEntityID[0]);
            projs = new EZProjectIDSg[ids.length];
            EZEntityID id = null;
            int i = 0;
            while (i < ids.length) {
                id = ids[i];
                projs[i] = (EZProjectIDSg)id.getSegment(EZProjectIDSg.class);
                ++i;
            }
        }
        return projs;
    }

    public Object getAdapter(Class adapterClass) {
        IAdapterManager manager = Platform.getAdapterManager();
        Object adapter = manager.getAdapter((Object)this, adapterClass);
        if (adapter == null) {
            adapter = manager.loadAdapter((Object)this, adapterClass.getName());
        }
        return adapter;
    }

    public Object getAdapter(String adapterClass) {
        IAdapterManager manager = Platform.getAdapterManager();
        Object adapter = manager.getAdapter((Object)this, adapterClass);
        if (adapter == null) {
            adapter = manager.loadAdapter((Object)this, adapterClass);
        }
        return adapter;
    }

    public void registerProject(IResource resource, boolean refreshModel, EZProjectInstantiator instantiator) {
        if (!this.projectsMap.containsKey(resource.getName())) {
            EZProject ezProject = instantiator.instantiate((IProject)resource, false);
            EZEntityID id = this.newProjectID(ezProject);
            this.projectsMap.put(resource.getName(), id);
            WorkspaceLogUtil.info(Messages.getString(EZWorkspace.class, "register.project.log", new String[]{resource.getName()}));
        } else {
            WorkspaceLogUtil.info(Messages.getString(EZWorkspace.class, "project.registered.already.log", new String[]{resource.getName()}));
        }
        if (refreshModel) {
            this.getPrjModel(resource);
        }
    }

    public EZEntityID getProjID(IResource resource) {
        EZEntityID entityID = this.projectsMap.get(resource.getName());
        return entityID;
    }

    public EZProject getPrjModel(IResource resource) {
        EZEntityID entityID = this.projectsMap.get(resource.getName());
        EZProject proj = null;
        if (entityID != null && (proj = this.getEZProject(entityID)) != null && proj.getInfo() == null) {
            proj.init();
        }
        return proj;
    }

    public void unregisterProject(IResource resource, boolean saveInfo) {
        EZEntityID entityID = this.projectsMap.get(resource.getName());
        if (entityID != null) {
            EZProject proj = this.getEZProject(entityID);
            if (proj != null) {
                if (saveInfo) {
                    boolean owner = com.ez.workspace.mu.client.Utils.isOwner(proj.getProject());
                    if (owner) {
                        proj.saveInfo(false);
                    } else {
                        L.debug("not save project's model; client is not owner");
                    }
                }
                this.projectsMap.remove(resource.getName());
                WorkspaceLogUtil.info(Messages.getString(EZWorkspace.class, "unregister.project.log", new String[]{resource.getName()}));
            } else {
                WorkspaceLogUtil.info(Messages.getString(EZWorkspace.class, "prj.log", new String[]{resource.getName()}));
            }
        }
    }

    public EZProject getEZProject(EZEntityID entityID) {
        EZProject proj = null;
        EZProjectIDSg projID = (EZProjectIDSg)entityID.getSegment(EZProjectIDSg.class);
        proj = projID.getEzProject();
        return proj;
    }

    public static boolean hasNature(IProject project, String natureID) {
        return Utils.hasNature((IProject)project, (String)natureID);
    }

    public EZEntityID newProjectID(EZProject project) {
        EZEntityID projID = new EZEntityID();
        EZProjectIDSg projSG = new EZProjectIDSg(project);
        projID.addSegment((EZSegment)projSG);
        return projID;
    }

    public EZEntityID getModelEntityID(IResource resource) {
        EZEntityID modelID = null;
        IProject prj = resource.getProject();
        EZEntityID prjID = this.getProjID((IResource)prj);
        if (prjID != null) {
            EZProjectIDSg prjSg = (EZProjectIDSg)prjID.getSegment(EZProjectIDSg.class);
            EZProject project = prjSg.getEzProject();
            modelID = project.getModelID(resource);
        }
        return modelID;
    }

    private void loadAnalysis() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ACTIONS_EXTENSION_POINT);
        if (point == null) {
            WorkspaceLogUtil.err(Messages.getString(EZWorkspace.class, "notRegistered.log", new String[]{ACTIONS_EXTENSION_POINT}), null);
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            if (configElements != null) {
                int j = 0;
                while (j < configElements.length) {
                    EZAnalysisType aType = this.getAnalysisType(configElements[j]);
                    this.registerAnalysisType(aType);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void loadCategories() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ANALYSIS_CATEGORY_EXTENSION_POINT);
        if (point == null) {
            WorkspaceLogUtil.err(Messages.getString(EZWorkspace.class, "notRegistered.log", new String[]{ANALYSIS_CATEGORY_EXTENSION_POINT}), null);
            return;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            if (configElements != null) {
                IConfigurationElement[] iConfigurationElementArray = configElements;
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    this.loadCategory(config);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void loadCategory(IConfigurationElement element) {
        Category c = new Category(element.getAttribute(ANALYSIS_ATTR_ID), element.getAttribute(ANALYSIS_ATTR_NAME));
        String iconPath = element.getAttribute(ANALYSIS_ATTR_ICON);
        if (iconPath != null) {
            ImageDescriptor imgDescriptor = Activator.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath);
            c.setImageDescriptor(imgDescriptor);
        }
        c.setCategory(element.getAttribute(ANALYSIS_ATTR_CATEGORY));
        this.categoryManager.register(c);
    }

    private void registerAnalysisType(EZAnalysisType type) {
        if (type != null) {
            this.analysisTypes.add(type);
            CategoryEntry ce = new CategoryEntry(type.getId(), type.getName());
            ce.setBundle(type.getBundle());
            ce.setImageDescriptor(type.getIconDescriptor());
            ce.setAnalysisType(type);
            ce.setCategory(type.getCategory());
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.ez.category.favourite");
            if (preferences.getBoolean(ce.getId(), Boolean.FALSE.booleanValue())) {
                L.debug(" {} is considered favourite analysis", (Object)ce.getName());
                ce.setCategory("com.ez.category.favourite");
            }
            ce.setHasSettings(type.hasSettings());
            ce.setViewId(type.getViewId());
            this.categoryManager.register(ce);
        }
    }

    private EZAnalysisType getAnalysisType(IConfigurationElement element) {
        EZAnalysisType ret = null;
        String classAnalysis = element.getAttribute("class");
        boolean value = Registry.getInstance().check(classAnalysis);
        PlatformUI.getPreferenceStore().firePropertyChangeEvent("action", (Object)new Boolean(false), (Object)new Boolean(value));
        if (value) {
            String inputClass;
            ret = new EZAnalysisType();
            IContributor contributor = element.getContributor();
            Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
            ret.setVariant(element.getAttribute(ANALYSIS_ATTR_VARIANT));
            ret.setName(element.getAttribute(ANALYSIS_ATTR_NAME));
            ret.setClazz(this.getClassFromAttribute(element, contributorBundle, "class"));
            ret.setId(element.getAttribute(ANALYSIS_ATTR_ID));
            ret.setCategory(element.getAttribute(ANALYSIS_ATTR_CATEGORY));
            String hasSettings = element.getAttribute(ANALYSIS_ATTR_HASSETTINGS);
            if (hasSettings != null) {
                ret.setHasSettings(Boolean.parseBoolean(hasSettings));
            }
            if ((inputClass = element.getAttribute(ANALYSIS_INPUT_FILTER_CLAZZ)) != null) {
                ret.setInputFilterClazz(this.getClassFromAttribute(element, contributorBundle, ANALYSIS_INPUT_FILTER_CLAZZ));
            } else {
                IConfigurationElement[] filters = element.getChildren(ANALYSIS_INPUT_FILTER_CLAZZ);
                if (filters != null && filters.length > 0) {
                    if (filters.length != 1) {
                        L.warn("analysis {} has many filters! only first it will be considered", (Object)ret.getName());
                    } else {
                        IConfigurationElement filter = filters[0];
                        Class inClass = this.getClassFromAttribute(filter, contributorBundle, "class");
                        if (inClass != null) {
                            ret.setInputFilterClazz(inClass);
                            IConfigurationElement[] params = filter.getChildren("param");
                            if (params != null) {
                                Properties parameters = new Properties();
                                int j = 0;
                                while (j < params.length) {
                                    IConfigurationElement param = params[j];
                                    String name = param.getAttribute(ANALYSIS_ATTR_NAME);
                                    String strvalue = param.getAttribute("value");
                                    parameters.setProperty(name, strvalue);
                                    ++j;
                                }
                                if (!parameters.isEmpty()) {
                                    ret.setParameters(parameters);
                                }
                            }
                        } else {
                            L.warn("filter without className!");
                        }
                    }
                } else {
                    L.debug("analysis without filter: {}", (Object)ret.getName());
                }
            }
            String iconPath = element.getAttribute(ANALYSIS_ATTR_ICON);
            if (iconPath != null) {
                ImageDescriptor imgDescriptor = Activator.imageDescriptorFromPlugin((String)contributor.getName(), (String)iconPath);
                ret.setIconDescriptor(imgDescriptor);
            }
            IConfigurationElement[] inputs = element.getChildren(ANALYSIS_ELEMENT_INPUT);
            int i = 0;
            while (i < inputs.length) {
                Class inClass = this.getClassFromAttribute(inputs[i], contributorBundle, "class");
                Class ctxClass = this.getClassFromAttribute(inputs[i], contributorBundle, ANALYSIS_INPUT_ATTR_CONTEXT);
                if (inClass != null && ctxClass != null && this.testAvailability(inputs[i])) {
                    AnalysisInputType ait = new AnalysisInputType();
                    ait.setInput(inClass);
                    ait.setContext(ctxClass);
                    String eqString = inputs[i].getAttribute(ANALYSIS_INPUT_ATTR_EQUALS);
                    if ("true".equalsIgnoreCase(eqString)) {
                        ait.setEquals(true);
                    }
                    if ("false".equalsIgnoreCase(eqString)) {
                        ait.setEquals(false);
                    }
                    ret.addInputType(ait);
                }
                ++i;
            }
            ret.setViewId(element.getAttribute(ANALYSIS_ATTR_VIEWID));
        }
        return ret;
    }

    private boolean testAvailability(IConfigurationElement input) {
        String availability = input.getAttribute(ANALYSIS_INPUT_ATTR_AVAILABILITY);
        if (availability == null) {
            return true;
        }
        String result = System.getProperty(availability);
        return result != null && !result.equalsIgnoreCase("false");
    }

    private Class getClassFromAttribute(IConfigurationElement element, Bundle bundle, String attribute) {
        Class clazz = null;
        try {
            String className = element.getAttribute(attribute);
            if (className != null) {
                clazz = bundle.loadClass(className);
            }
        }
        catch (ClassNotFoundException ex) {
            L.warn("{} class can't be loaded by {}", new Object[]{attribute, bundle.getSymbolicName(), ex});
        }
        return clazz;
    }

    public List<EZAnalysisType> getRegisteredAnalysisTypes() {
        return this.analysisTypes;
    }

    public void removeJob(EZEntityID id, Class<? extends Job> jobClass, GraphTranslateJob jobInstance) {
        if (!this.jobs.isEmpty()) {
            Map<Class<? extends Job>, Set<GraphTranslateJob>> jbs = this.jobs.get(id);
            if (jbs != null && !jbs.isEmpty()) {
                Set<GraphTranslateJob> ids;
                if (jobClass == null && jobInstance != null) {
                    jobClass = jobInstance.getClass();
                }
                if ((ids = jbs.get(jobClass)) != null) {
                    ids.remove(jobInstance);
                    if (ids.isEmpty()) {
                        jbs.remove(jobClass);
                    }
                    if (jbs.isEmpty()) {
                        this.jobs.remove(id);
                    }
                } else {
                    L.info("no job to be removed for jobClass={}", jobClass);
                }
            } else {
                L.info("no job to be removed?! jobClass={}", jobClass);
            }
        }
    }

    public GraphTranslateJob getJob(EZEntityID id, Class<? extends Job> jobClass) {
        Set<GraphTranslateJob> ids;
        ISchedulingRule rule = null;
        Map<Class<? extends Job>, Set<GraphTranslateJob>> idJobs = this.jobs.get(id);
        if (idJobs == null) {
            idJobs = new HashMap<Class<? extends Job>, Set<GraphTranslateJob>>();
            this.jobs.put(id, idJobs);
        }
        if ((ids = idJobs.get(jobClass)) == null) {
            ids = new HashSet<GraphTranslateJob>();
            idJobs.put(jobClass, ids);
        } else {
            GraphTranslateJob g = ids.iterator().next();
            if (g instanceof Job) {
                rule = ((Job)g).getRule();
            }
        }
        GraphTranslateJob job = null;
        String msgError = Messages.getString(EZWorkspace.class, "getNewJob.err", new String[]{jobClass.toString()});
        Exception ex = null;
        try {
            job = (GraphTranslateJob)jobClass.getConstructor(EZEntityID.class).newInstance(id);
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        if (ex != null) {
            WorkspaceLogUtil.err(msgError, ex);
            L.error("Exception at getting a new instance of jobclass: {}", jobClass, (Object)ex);
        } else {
            if (job instanceof Job) {
                if (rule == null) {
                    rule = new SameJobRule();
                }
                ((Job)job).setRule(rule);
            }
            ids.add(job);
        }
        return job;
    }

    public void updateId(EZEntityID id) {
    }

    public List<EZAnalysisType> getSpecificAnalysisType(EZObjectType ait1) {
        ArrayList<EZAnalysisType> result = null;
        if (this.analysisTypes.size() > 0) {
            if (result == null) {
                result = new ArrayList<EZAnalysisType>();
            }
            block0: for (EZAnalysisType analysisType : this.analysisTypes) {
                Iterator<AnalysisInputType> aIt = analysisType.getInputsIterator();
                while (aIt.hasNext()) {
                    AnalysisInputType ait2 = aIt.next();
                    Class cls2 = ait2.getInput();
                    Class<?> cls1 = ait1.getClass();
                    if (!cls1.equals(cls2)) continue;
                    Class ctx2 = ait2.getContext();
                    Class ctx1 = ait1.getContext();
                    if (ctx2 == IgnoreContext.class) {
                        this.addToResult(analysisType, result);
                        continue block0;
                    }
                    if (ait2.isEquals()) {
                        if (ctx1 != ctx2) continue;
                        this.addToResult(analysisType, result);
                        continue block0;
                    }
                    if (ctx1 == ctx2) continue;
                    this.addToResult(analysisType, result);
                    continue block0;
                }
            }
        }
        return result;
    }

    private void addToResult(EZAnalysisType analysisType, List<EZAnalysisType> result) {
        result.add(analysisType);
    }

    public EZAnalysisType getSpecificAnalysisType(EZObjectType inputType, Class analysisToFilter) {
        return this.getSpecificAnalysisType(inputType, analysisToFilter, null);
    }

    public EZAnalysisType getSpecificAnalysisType(EZObjectType inputType, Class analysisToFilter, String variant) {
        EZAnalysisType analysisType2 = null;
        List<EZAnalysisType> analysisTypes = this.getSpecificAnalysisType(inputType);
        if (analysisTypes != null) {
            for (EZAnalysisType analysisType2 : analysisTypes) {
                if (analysisToFilter == analysisType2.getClazz()) {
                    if (variant == null || variant.equals(analysisType2.getVariant())) break;
                    analysisType2 = null;
                    continue;
                }
                analysisType2 = null;
            }
        }
        return analysisType2;
    }

    public EZAnalysisType getAnalysisById(String id) {
        for (EZAnalysisType t : this.analysisTypes) {
            if (t.getId().compareTo(id) != 0) continue;
            return t;
        }
        return null;
    }

    public EZAnalysisType getSpecificAnalysisType(EZObjectType inputType, String analysisTypeId) {
        EZAnalysisType analysisType2 = null;
        List<EZAnalysisType> analysisTypes = this.getSpecificAnalysisType(inputType);
        if (analysisTypes != null) {
            for (EZAnalysisType analysisType2 : analysisTypes) {
                if (analysisTypeId.equals(analysisType2.getId())) break;
                analysisType2 = null;
            }
        }
        return analysisType2;
    }

    public boolean hasAnalysis(String className) {
        boolean ret = false;
        for (EZAnalysisType aType : this.analysisTypes) {
            Class analysisClazz = aType.getClazz();
            if (!analysisClazz.getName().equals(className)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public List<EZAnalysisType> filterAnalysis(List<EZAnalysisType> filtersId) {
        List<EZAnalysisType> filteredAnalysis = null;
        if (filtersId != null && filtersId.size() > 0) {
            filteredAnalysis = new ArrayList<EZAnalysisType>();
            for (EZAnalysisType type : this.analysisTypes) {
                String id = type.getId();
                if (filtersId.contains(id)) continue;
                filteredAnalysis.add(type);
            }
        } else {
            filteredAnalysis = this.analysisTypes;
        }
        return filteredAnalysis;
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    private class SameJobRule
    implements ISchedulingRule {
        private SameJobRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule.equals(this);
        }

        public boolean contains(ISchedulingRule rule) {
            L.trace("SameJobRule.contains rule={}", (Object)rule);
            return rule.equals(this);
        }
    }
}

