/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.workspace.internal.Messages;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZProjectInstantiator;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final EZWorkspace INSTANCE = EZWorkspace.getInstance();
    private EZProject abapPrj;
    private static Logger logger = LoggerFactory.getLogger(EZResourceChangeListener.class);
    private Set ignoreChanges = new HashSet();

    public boolean visit(IResourceDelta delta) {
        IResource res = delta.getResource();
        IProject prj = res.getProject();
        int flags = delta.getFlags();
        if (res.getType() == 4) {
            logger.info("project: {}, flags: {}", (Object)res.getName(), (Object)flags);
        }
        if (flags != 0) {
            EZProjectInstantiator instantiator;
            if ((flags & 0x4000) != 0) {
                prj = (IProject)res;
                if (prj.isAccessible() && (instantiator = INSTANCE.getInstantiator(prj)) != null) {
                    INSTANCE.registerProject((IResource)prj, true, instantiator);
                }
            } else if (this.ignoreChanges.contains(delta)) {
                this.ignoreChanges.remove(delta);
            } else {
                if (this.abapPrj == null || !this.abapPrj.getProject().equals((Object)res.getProject())) {
                    this.abapPrj = INSTANCE.getPrjModel((IResource)res.getProject());
                }
                if (this.abapPrj != null) {
                    int length;
                    if ((flags & 0x1000) != 0) {
                        IPath newPath = res.getFullPath();
                        IPath oldPath = delta.getMovedFromPath();
                        length = Math.max(newPath.segments().length, oldPath.segments().length);
                        if (newPath.matchingFirstSegments(oldPath) != length - 1) {
                            this.abapPrj.removeResource(res, false);
                        }
                    } else if ((flags & 0x2000) != 0) {
                        IPath oldPath = res.getFullPath();
                        IPath newPath = delta.getMovedToPath();
                        length = Math.max(newPath.segments().length, oldPath.segments().length);
                        if (newPath.matchingFirstSegments(oldPath) == length - 1) {
                            this.abapPrj.renameFile(res, newPath);
                        } else {
                            this.abapPrj.removeResource(res, true);
                        }
                    } else {
                        if (res.getType() == 4 && delta.getKind() == 1) {
                            logger.debug("=====================> added");
                            instantiator = INSTANCE.getInstantiator((IProject)res);
                            if (instantiator != null) {
                                INSTANCE.registerProject(res, true, instantiator);
                            }
                        }
                        if ((flags & 0x800) != 0) {
                            logger.debug("resource <{}> has COPIED_FROM flag", (Object)res.getName());
                        } else if ((flags & 0x40000) != 0) {
                            logger.debug("resource <{}> has REPLACED flag", (Object)res.getName());
                        } else if ((flags & 0x20000) != 0 || (flags & 0x100) == 0) {
                            // empty if block
                        }
                    }
                }
            }
            int i = 0;
            while (i < delta.getAffectedChildren().length) {
                IResourceDelta d = delta.getAffectedChildren()[i];
                this.ignoreChanges.add(d);
                ++i;
            }
        } else if (prj != null && prj.isOpen()) {
            switch (delta.getKind()) {
                case 1: {
                    if (res.getType() != 4) break;
                    logger.debug("Project <{}> was added.", (Object)res.getName());
                    break;
                }
                case 2: {
                    if (this.abapPrj == null || !this.abapPrj.getProject().equals((Object)res.getProject())) {
                        this.abapPrj = INSTANCE.getPrjModel((IResource)res.getProject());
                    }
                    if (this.abapPrj == null) break;
                    this.abapPrj.removeResource(res, true);
                    break;
                }
                case 4: {
                    logger.debug("Resource {} was changed.", (Object)res.getFullPath());
                }
            }
        }
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource res = event.getResource();
        try {
            switch (event.getType()) {
                case 2: {
                    logger.debug("Project <{}> is about to close.", (Object)res.getName());
                    INSTANCE.unregisterProject(res, true);
                    break;
                }
                case 4: {
                    logger.debug("Project <{}> is about to be deleted.", (Object)res.getName());
                    INSTANCE.unregisterProject(res, false);
                    break;
                }
                case 1: {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                case 16: {
                    if (event.getBuildKind() != 0) break;
                    logger.debug("POST_BUILD; {}", (Object)event.getType());
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                default: {
                    break;
                }
            }
        }
        catch (CoreException e) {
            WorkspaceLogUtil.err(Messages.getString(EZResourceChangeListener.class, "logView.error.message"), e);
            logger.error("error handling events", (Throwable)e);
        }
    }
}

