/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.workspace.model.Utils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZProjectNature
implements IProjectNature {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZProjectNature.class);
    private IProject project;

    public void configure() throws CoreException {
        L.info("configure nature: {}", (Object)this.getNatureID());
        boolean added = Utils.addBuilder(this.project, this.getBuilderID());
        L.debug("builder {} was added={}", (Object)this.getBuilderID(), (Object)added);
    }

    public void deconfigure() throws CoreException {
        L.info("deconfigure nature: {}", (Object)this.getNatureID());
        boolean removed = Utils.removeBuilder(this.project, this.getBuilderID());
        L.debug("builder {} was removed={}", (Object)this.getBuilderID(), (Object)removed);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public abstract String getNatureID();

    public abstract String getBuilderID();
}

