/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class EZProjectInfo
implements Serializable {
    protected HashMap<Integer, Set<String>> allLists;
    public String name;
    protected String linkBase = null;

    public void setLinkBase(String externalPath) {
        this.linkBase = externalPath;
    }

    public String getLinkBase() {
        return this.linkBase;
    }

    public Set getList(int kind) {
        return this.allLists.get(new Integer(kind));
    }

    public Map getAllLists() {
        return this.allLists;
    }

    public void setListWithKind(Set set, Integer kind) {
        if (set != null) {
            this.allLists.put(new Integer(kind), set);
        }
    }

    public void addAll(Set newSet, Integer kind) {
        Set set = this.getList(kind);
        for (String folder : newSet) {
            set.add(folder);
        }
    }

    public void addFolder(String element, int kind) {
        Set set = this.getList(kind);
        if (set != null) {
            set.add(element);
        }
    }

    public void removeFolder(String folder, int kind) {
        Set<String> fold = this.allLists.get(new Integer(kind));
        if (fold != null) {
            fold.remove(folder);
        }
    }

    public void renameFolder(String oldPath, String newPath, int kind) {
        Set<String> foldersList = this.allLists.get(new Integer(kind));
        if (foldersList != null && foldersList.contains(oldPath)) {
            foldersList.remove(oldPath);
            foldersList.add(newPath);
        }
    }

    public boolean isEmpty() {
        if (this.allLists != null && !this.allLists.isEmpty()) {
            for (Integer kind : this.allLists.keySet()) {
                Set<String> st = this.allLists.get(kind);
                if (st == null || st.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public void cleanForKind(int kind) {
        Set set = this.getList(kind);
        set.clear();
    }

    public void clean() {
        for (Integer kind : this.allLists.keySet()) {
            this.allLists.put(kind, new HashSet());
        }
    }
}

