/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.internal.analysis.config.inputs.EZProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.model.EZProxy;
import com.ez.workspace.Activator;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.model.EZProjectInfo;
import com.ez.workspace.model.ProxyRegistry;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZProject {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZProject.class);
    protected IProject project = null;
    public static final String PROPERTIES_FILE = ".prop";
    protected ProxyRegistry proxiesMap = new ProxyRegistry();

    public abstract boolean toBuild(IResource var1);

    public abstract boolean toUnmarshall(IResource var1);

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.project.getName();
    }

    public IPath getLocation() {
        return this.project.getLocation();
    }

    public abstract void saveInfo(boolean var1);

    public abstract EZProjectInfo getInfo();

    protected abstract void init();

    protected abstract void renameFile(IResource var1, IPath var2);

    protected abstract void removeResource(IResource var1, boolean var2);

    public abstract EZEntityID getModelID(IResource var1);

    public abstract EZEntityID getLightModelID(IResource var1);

    public abstract String getLabel4Navigator(IResource var1);

    public abstract Image getImage4Navigator(IResource var1);

    public abstract Image getImage4Type(int var1);

    public static Image getDefaultImage(IResource res) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        switch (res.getType()) {
            case 1: {
                return workbench.getSharedImages().getImage("IMG_OBJ_FILE");
            }
            case 2: {
                return workbench.getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            case 4: {
                if (((IProject)res).isOpen()) {
                    return workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
                return workbench.getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
            }
        }
        return null;
    }

    public abstract int getDefaultKind();

    public abstract IResource getResource(String var1, int var2);

    public abstract Set<IResource> getResources(Integer var1, List<String> var2);

    public Set<IResource> getResources(Integer resType, List<String> acceptedExtensions, HashSet<String> ignoredNames) {
        if (ignoredNames == null || ignoredNames.isEmpty()) {
            return this.getResources(resType, acceptedExtensions);
        }
        return null;
    }

    public abstract String getStringTypeByKind(Integer var1);

    public abstract int getResourceType(IResource var1, EZProjectInfo var2, boolean var3);

    public Set<IResource> getRootFolders() {
        HashSet<IResource> result = null;
        try {
            IResource[] all = this.getProject().members();
            result = new HashSet<IResource>();
            IResource[] iResourceArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                IResource each = iResourceArray[n2];
                if (each.getType() == 2) {
                    result.add(each);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            L.error("Cannot get root folders for project {}", (Object)this.getProject().getName());
        }
        return result;
    }

    public abstract List getHiddenResources();

    public abstract boolean areAnnotationsAvailable(IResource var1);

    public abstract String getFilterStringForProxy(int var1);

    public abstract Integer getDBType(IResource var1, Integer var2);

    public String toString() {
        return this.getName();
    }

    public abstract boolean acceptAnnotation();

    public static File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getLocation();
        return workingLocation.addTrailingSeparator().append(PROPERTIES_FILE).toFile();
    }

    public abstract void cleanProxies();

    public abstract EZProjectInfo readInfo(IProject var1);

    public abstract void setInfo(EZProjectInfo var1);

    public abstract Object getPropertiesContributor(Object var1, Class var2);

    public abstract EZProxy buildProxy(Integer var1);

    protected boolean listContainsPath(Set list, IPath path, boolean deepSearch) {
        String strPath = path.toOSString();
        if (list != null) {
            if (list.contains(strPath)) {
                return true;
            }
            if (deepSearch) {
                for (String strPth : list) {
                    Path p;
                    int match;
                    if (strPth == null || (match = path.matchingFirstSegments((IPath)(p = new Path(strPth)))) <= 0 || match != p.segmentCount()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public abstract boolean isVisibleResource(IResource var1);

    protected IResource findResource(String name, Object[] searchIn) {
        int i = 0;
        while (i < searchIn.length) {
            if (searchIn[i] instanceof IResource) {
                IResource res = (IResource)searchIn[i];
                if (!res.isDerived() && !res.getName().startsWith(".")) {
                    if (res.getName().equalsIgnoreCase(name)) {
                        return res;
                    }
                    if (res instanceof IContainer) {
                        IContainer parent = (IContainer)res;
                        try {
                            IResource ret = this.findResource(name, parent.members());
                            if (ret != null) {
                                return ret;
                            }
                        }
                        catch (CoreException e) {
                            L.error("not found resource with name {} in project {}", new Object[]{name, this.getName(), e});
                        }
                    }
                }
            } else {
                Object[] param = new String[]{name};
                WorkspaceLogUtil.warn(Messages.getString(EZProject.class, "resource.not.found.warn", param), null);
            }
            ++i;
        }
        return null;
    }

    public Class getProxyClass(IFile res) {
        return null;
    }

    public EZProjectInputType getProjectInputTypeInstance() {
        return new EZProjectInputType();
    }

    protected IResource[] getResources(String[] resNames) {
        IResource[] ret = new IResource[resNames.length];
        int i = 0;
        while (i < resNames.length) {
            IResource found = this.getProject().findMember(resNames[i]);
            if (found != null && found.exists()) {
                ret[i] = found;
            }
            ++i;
        }
        return ret;
    }
}

