/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZAnalysisJobListener
implements IJobChangeListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZAnalysisJobListener.class);
    private IViewPart view = null;

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
        IWorkbench workbench;
        Job job = event.getJob();
        if (job.belongsTo((Object)"GRAPH_JOB") && (workbench = PlatformUI.getWorkbench()) != null) {
            IWorkbenchWindow[] wws = workbench.getWorkbenchWindows();
            if (wws != null && wws.length > 0) {
                IWorkbenchWindow ww = wws[0];
                IWorkbenchPage[] wps = ww.getPages();
                if (wps != null && wps.length > 0) {
                    final IWorkbenchPage page = wps[0];
                    final IViewReference viewRef = page.findViewReference("com.ez.analysis.display.view.GraphsView");
                    if (viewRef == null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    L.debug("open the analysis view");
                                    EZAnalysisJobListener.this.view = page.showView("com.ez.analysis.display.view.GraphsView");
                                }
                                catch (PartInitException pie) {
                                    L.error("could not open analysis view", (Throwable)pie);
                                }
                            }
                        });
                    } else if (this.view == null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                L.debug("create analysis view");
                                EZAnalysisJobListener.this.view = viewRef.getView(true);
                            }
                        });
                    }
                } else {
                    L.error("no workbenchpage is available");
                }
            } else {
                L.error("no workbenchwindow is available");
            }
        }
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

