/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.model;

import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.analysis.category.ICategoryEntry;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.model.CategoryEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CategoryManager.class);
    public static final String OTHER_ID = "com.ez.workspace.category.other";
    public static final String FAVOURITE_ID = "com.ez.category.favourite";
    public static final String FAVOURITE_NAME = Messages.getString(CategoryManager.class, "favorite.name");
    private Map<String, ICategory> categories = new HashMap<String, ICategory>();
    private Map<String, ICategoryEntry> entries = new HashMap<String, ICategoryEntry>();
    private Map<String, Map<String, ICategory>> data = new HashMap<String, Map<String, ICategory>>();

    public ICategory getCategory(String id) {
        return this.categories.get(id);
    }

    public void register(ICategory category) {
        this.registerRaw(category);
        this.categories.put(category.getId(), category);
    }

    public void register(ICategoryEntry categoryEntry) {
        this.registerRaw(categoryEntry);
        this.entries.put(categoryEntry.getId(), categoryEntry);
    }

    private void unregisterRaw(ICategory elem) {
        String cid = elem.getCategory();
        Map<String, ICategory> children = this.data.get(cid);
        if (children != null) {
            children.remove(elem.getId());
        }
    }

    private void registerRaw(ICategory elem) {
        String cid = elem.getCategory();
        Map<String, ICategory> children = this.data.get(cid);
        if (children == null) {
            children = new HashMap<String, ICategory>();
            this.data.put(cid, children);
        }
        children.put(elem.getId(), elem);
    }

    public Collection<ICategory> categories() {
        return this.categories.values();
    }

    public Collection<ICategory> getEntries(String cid) {
        Map<String, ICategory> children = this.data.get(cid);
        if (children != null) {
            return children.values();
        }
        return null;
    }

    public ICategoryEntry getCategoryEntry(String id) {
        return this.entries.get(id);
    }

    public Collection<ICategory> getTopCategories() {
        ArrayList<ICategory> top = new ArrayList<ICategory>();
        for (ICategory c : this.categories.values()) {
            if (c.getCategory() != null) continue;
            top.add(c);
        }
        return top;
    }

    public void switchCategory(CategoryEntry catEntry) {
        String category = catEntry.getCategory();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(FAVOURITE_ID);
        if (FAVOURITE_ID.equals(category)) {
            this.unregisterRaw(catEntry);
            catEntry.setCategory(catEntry.getOriginalCategory());
            this.register(catEntry);
            preferences.remove(catEntry.getId());
            L.debug("remove {} from favorites", (Object)catEntry.getName());
        } else {
            this.unregisterRaw(catEntry);
            catEntry.setCategory(FAVOURITE_ID);
            this.register(catEntry);
            preferences.putBoolean(catEntry.getId(), Boolean.TRUE.booleanValue());
            L.debug("remove {} from favorites", (Object)catEntry.getName());
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            L.warn("can not persist information about {}; see exception: {} ", (Object)catEntry.getName(), (Object)e);
        }
    }
}

