/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change.persist;

import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.EZChangingManager;
import com.ez.workspace.change.EZModifyResourceProvider;
import com.ez.workspace.change.persist.ChangingPropBuilder;
import com.ez.workspace.change.persist.ChangingPropObject;
import com.ez.workspace.change.persist.ChangingPropReader;
import com.ez.workspace.change.persist.ChangingPropWriter;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZResourceManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZResourceManager.class);
    private Map<IProject, Map<IResource, DirtyStatus>> model = new HashMap<IProject, Map<IResource, DirtyStatus>>();
    private Map<IProject, Set<IFolder>> folders = new HashMap<IProject, Set<IFolder>>();
    private Map<IResource, Set<IResource>> tree = new HashMap<IResource, Set<IResource>>();
    private EZModifyResourceProvider resourceProvider;

    public EZResourceManager(EZModifyResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public void buildChangingModel(IResource resource, DirtyStatus type) {
        this.handleModel(resource, type);
    }

    public void handleEmptyFolders4Projects(Set<IProject> projects) {
        if (projects != null && !projects.isEmpty()) {
            for (IProject project : projects) {
                this.resolveEmptyFolders(project);
            }
        }
    }

    private boolean isFolderEmpty(IFolder folder) {
        boolean result = false;
        Set<IResource> children = this.tree.get(folder);
        if (children == null || children.isEmpty()) {
            result = true;
        }
        return result;
    }

    private void resolveEmptyFolders(IProject project) {
        Set<IFolder> dirs;
        if (project != null && (dirs = this.folders.get(project)) != null) {
            HashSet<IFolder> empty = new HashSet<IFolder>();
            for (IFolder folder : dirs) {
                if (folder == null || !this.isFolderEmpty(folder)) continue;
                empty.add(folder);
            }
            for (IFolder dir : empty) {
                this.buildChangingModel((IResource)dir, DirtyStatus.BUILT_REQUIRE_REFRESH);
            }
            empty.clear();
        }
    }

    public void load() {
        EZProject[] projects = EZWorkspace.getInstance().getProjects();
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                IProject proj;
                EZProject project = projects[i];
                if (project != null && (proj = project.getProject()) != null) {
                    ChangingPropReader reader = new ChangingPropReader(proj);
                    reader.read();
                    reader.clearCollections();
                    Map<IResource, DirtyStatus> map = reader.getResultMap();
                    this.fillTree4Project(map);
                    this.model.put(proj, map);
                    this.fillFoldersMap(proj, map);
                }
                ++i;
            }
        }
        this.check4ErroneousBehaviour();
    }

    private void fillFoldersMap(IProject project, Map<IResource, DirtyStatus> map) {
        if (project != null && map != null && !map.isEmpty()) {
            for (IResource resource : map.keySet()) {
                if (resource == null || resource.getType() != 2) continue;
                Set<IFolder> dirs = this.folders.get(project);
                if (dirs == null) {
                    dirs = new HashSet<IFolder>();
                    this.folders.put(project, dirs);
                }
                dirs.add((IFolder)resource);
            }
        }
    }

    public void addedNewResource(IResource resource) {
        if (resource != null) {
            if (resource.getType() == 1) {
                this.addDirty(resource, DirtyStatus.CLEAN_OR_NO_MODEL);
            } else {
                this.removeDirty(resource, DirtyStatus.BUILT_REQUIRE_REFRESH);
            }
        }
    }

    public void moveOrRenameResource(IResource oldOne, IResource newOne) {
        Map<IResource, DirtyStatus> map;
        if (newOne.getType() == 4) {
            map = this.getMapOfResource(oldOne);
            if (map != null) {
                this.model.put((IProject)newOne, map);
            } else {
                map = this.getMapOfResource(newOne);
                if (map != null) {
                    this.model.put((IProject)newOne, map);
                }
            }
        } else {
            DirtyStatus status;
            map = this.getMapOfResource(oldOne);
            if (map != null && (status = map.get(oldOne)) != null) {
                map.put(newOne, status);
            }
            this.removeFromFolders(oldOne);
            this.addToFolders(newOne);
        }
        Set<IResource> children = this.tree.get(oldOne);
        if (children != null) {
            this.tree.put(newOne, children);
        }
        if (oldOne.getType() != 4) {
            IContainer oldParent = oldOne.getParent();
            IContainer newParent = newOne.getParent();
            Set<IResource> oldSiblings = this.tree.get(oldParent);
            Set<IResource> newSiblings = this.tree.get(newParent);
            if (oldSiblings != null) {
                oldSiblings.remove(oldOne);
            }
            if (newSiblings != null) {
                newSiblings.add(newOne);
            }
        }
    }

    private void deleteResourceAndChildren(IResource resource) {
        if (resource != null) {
            Set<IFolder> dirs;
            IProject project;
            IContainer parent;
            Set<IResource> children;
            Map<IResource, DirtyStatus> map = this.getMapOfResource(resource);
            if (map != null) {
                map.put(resource, DirtyStatus.DELETED_RESOURCE);
            }
            if ((children = this.tree.get(resource)) != null && !children.isEmpty()) {
                for (IResource child : children) {
                    this.deleteResourceAndChildren(child);
                }
            }
            if ((parent = resource.getParent()) != null && (children = this.tree.get(parent)) != null && !children.isEmpty()) {
                children.remove(resource);
            }
            if (resource.getType() == 2 && (project = resource.getProject()) != null && (dirs = this.folders.get(project)) != null && !dirs.isEmpty() && dirs.contains(resource)) {
                dirs.remove(resource);
            }
        }
    }

    public void deletedResource(IResource resource) {
        Set<IResource> siblings;
        this.deleteResourceAndChildren(resource);
        IContainer parent = resource.getParent();
        if (parent != null && ((siblings = this.tree.get(parent)) == null || siblings.isEmpty())) {
            this.buildChangingModel((IResource)parent, DirtyStatus.BUILT_REQUIRE_REFRESH);
        }
        if (resource.getType() == 1) {
            this.resourceProvider.resourceModified(resource, DirtyStatus.DELETED_RESOURCE);
        }
    }

    private void check4ErroneousBehaviour() {
        ArrayList<IResource> unresolved = new ArrayList<IResource>();
        for (IProject project : this.model.keySet()) {
            Map<IResource, DirtyStatus> map;
            if (project == null || (map = this.model.get(project)) == null) continue;
            for (IResource resource : map.keySet()) {
                Set<IResource> children;
                DirtyStatus status;
                if (resource == null || (status = map.get(resource)) == null || resource.getType() != 2 && resource.getType() != 4 || (children = this.tree.get(resource)) != null && !children.isEmpty()) continue;
                unresolved.add(resource);
            }
        }
        if (!unresolved.isEmpty()) {
            EZChangingManager.getManager().notifyBuiltResources(unresolved);
        }
    }

    private void fillTree4Project(Map<IResource, DirtyStatus> map) {
        if (map != null && !map.isEmpty()) {
            for (IResource resource : map.keySet()) {
                if (resource == null) continue;
                this.fillTree(resource);
            }
        }
    }

    public void save() {
        Set<IProject> projects = this.model.keySet();
        for (IProject project : projects) {
            Map<IResource, DirtyStatus> map = this.model.get(project);
            if (map == null || project == null) continue;
            if (project.exists()) {
                this.saveProjectResources(map, project);
                continue;
            }
            L.debug("project {} was deleted from workspace", (Object)project.getName());
        }
    }

    private void saveProjectResources(Map<IResource, DirtyStatus> map, IProject project) {
        ChangingPropBuilder builder = new ChangingPropBuilder(project, map);
        builder.buildFromMap();
        Collection<ChangingPropObject> all = builder.getResult();
        ChangingPropWriter w = new ChangingPropWriter(all, project);
        w.write();
    }

    private Map<IResource, DirtyStatus> getMapOfResource(IResource resource) {
        IProject project;
        Map<IResource, DirtyStatus> result = null;
        if (resource != null && (result = this.model.get(project = resource.getProject())) == null) {
            result = new HashMap<IResource, DirtyStatus>();
            this.model.put(project, result);
        }
        return result;
    }

    private void handleModel(IResource resource, DirtyStatus type) {
        switch (type) {
            case BUILT_REQUIRE_REFRESH: {
                this.removeDirty(resource, type);
                break;
            }
            case CLEAN_OR_NO_MODEL: 
            case RESOURCE_MODIFIED_REQUIRE_BUILD: {
                if (resource.getName().startsWith(".")) break;
                this.addDirty(resource, type);
            }
        }
        if (type != DirtyStatus.MARKER_DIRTY_IGNORE) {
            this.resourceProvider.resourceModified(resource, type);
        } else {
            this.check4AncestorMarkers(resource);
        }
    }

    private void addDirty(IResource resource, DirtyStatus type) {
        Map<IResource, DirtyStatus> map = this.getMapOfResource(resource);
        if (map != null) {
            map.put(resource, type);
            this.addToAncestors(resource, type);
        }
        this.addToFolders(resource);
    }

    private void addToFolders(IResource resource) {
        IProject project;
        if (resource != null && resource.getType() == 2 && (project = resource.getProject()) != null) {
            Set<IFolder> dirs = this.folders.get(project);
            if (dirs == null) {
                dirs = new HashSet<IFolder>();
                this.folders.put(project, dirs);
            }
            dirs.add((IFolder)resource);
        }
    }

    private void removeFromFolders(IResource resource) {
        Set<IFolder> dirs;
        IProject project;
        if (resource != null && resource.getType() == 2 && (project = resource.getProject()) != null && (dirs = this.folders.get(project)) != null) {
            dirs.remove(resource);
        }
    }

    private void fillTree(IResource resource) {
        if (resource != null && resource.getParent() != null) {
            IContainer parent = resource.getParent();
            if (parent.getType() == 8) {
                return;
            }
            Set<IResource> children = this.tree.get(parent);
            if (children == null) {
                children = new HashSet<IResource>();
                this.tree.put((IResource)parent, children);
            }
            if (!"bak".equalsIgnoreCase(resource.getFileExtension()) && !resource.getName().startsWith(".")) {
                children.add(resource);
            }
        }
    }

    private void addToAncestors(IResource resource, DirtyStatus type) {
        if (resource != null && resource.getParent() != null) {
            IContainer parent = resource.getParent();
            if (parent.getType() == 8) {
                return;
            }
            Set<IResource> children = this.tree.get(parent);
            if (children == null) {
                children = new HashSet<IResource>();
                this.tree.put((IResource)parent, children);
            }
            if (!this.hasAlreadyDirtyType((IResource)parent, type)) {
                Map<IResource, DirtyStatus> map = this.getMapOfResource((IResource)parent);
                map.put((IResource)parent, type);
                this.addToFolders((IResource)parent);
                this.resourceProvider.resourceModified((IResource)parent, type);
            }
            if (!"bak".equalsIgnoreCase(resource.getFileExtension()) && !resource.getName().startsWith(".")) {
                children.add(resource);
            }
            if (parent.getType() != 4 && parent.getType() != 8) {
                Set<IResource> uncles = this.tree.get(parent.getParent());
                if (!this.hasAlreadyDirtyType((IResource)parent, type) || uncles == null || uncles != null && uncles.isEmpty()) {
                    this.addToAncestors((IResource)parent, type);
                }
            }
        }
    }

    private boolean hasAlreadyDirtyType(IResource resource, DirtyStatus status) {
        boolean result = false;
        Map<IResource, DirtyStatus> map = this.getMapOfResource(resource);
        if (map != null) {
            DirtyStatus oldStatus = map.get(resource);
            if (status != null && status == oldStatus) {
                result = true;
            }
        }
        return result;
    }

    private void check4AncestorMarkers(IResource resource) {
        DirtyStatus currentStatus;
        Map<IResource, DirtyStatus> map = this.getMapOfResource(resource);
        if (map != null && (currentStatus = map.get(resource)) == null) {
            this.removeFromAncestors(resource, DirtyStatus.BUILT_REQUIRE_REFRESH);
        }
    }

    private void removeDirty(IResource resource, DirtyStatus type) {
        Map<IResource, DirtyStatus> map = this.getMapOfResource(resource);
        if (map != null) {
            map.remove(resource);
            this.removeFromFolders(resource);
            this.removeFromAncestors(resource, type);
        }
    }

    private void removeFromAncestors(IResource resource, DirtyStatus type) {
        if (resource != null && resource.getParent() != null) {
            IContainer parent = resource.getParent();
            if (parent.getType() == 8) {
                return;
            }
            Set<IResource> children = this.tree.get(parent);
            if (children == null) {
                return;
            }
            children.remove(resource);
            if (children.isEmpty()) {
                Map<IResource, DirtyStatus> map = this.getMapOfResource((IResource)parent);
                map.remove(parent);
                this.removeFromFolders((IResource)parent);
                this.resourceProvider.resourceModified((IResource)parent, type);
            }
            if (parent.getType() != 4 && parent.getType() != 8) {
                this.removeFromAncestors((IResource)parent, type);
            }
        }
    }

    public DirtyStatus getDirtyType4Resource(IResource resource) {
        Map<IResource, DirtyStatus> types;
        IProject project;
        DirtyStatus result = null;
        if (resource != null && (project = resource.getProject()) != null && (types = this.model.get(project)) != null) {
            result = types.get(resource);
            if (resource.getType() == 4 && result == DirtyStatus.NONE) {
                return null;
            }
        }
        return result;
    }
}

