/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change.persist;

import com.ez.workspace.change.persist.ChangingPropObject;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangingPropWriter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ChangingPropWriter.class);
    public static final String DIRTY_FILE = ".dirty";
    private Collection<ChangingPropObject> list;
    private IProject project;
    private DataOutputStream out;

    public ChangingPropWriter(Collection<ChangingPropObject> list, IProject project) {
        this.list = list;
        this.project = project;
    }

    public void write() {
        String outputName = DIRTY_FILE;
        File projectFile = this.project.getLocation().toFile();
        File outputFile = new File(projectFile, outputName);
        try {
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            this.out.writeInt(this.list.size());
            for (ChangingPropObject o : this.list) {
                this.out.writeInt(o.getParentID());
                this.out.writeInt(o.getId());
                this.out.writeInt(o.getType().toInt());
                this.out.writeUTF(o.getName());
            }
            this.out.close();
        }
        catch (FileNotFoundException e) {
            L.error("File not found ", (Throwable)e);
        }
        catch (IOException e) {
            L.error("Cannot read dirty data", (Throwable)e);
        }
    }

    public static void deleteDirtyDataFile(IProject project) {
        if (project != null) {
            String inputName = DIRTY_FILE;
            File projectFile = project.getLocation().toFile();
            File inputFile = new File(projectFile, inputName);
            if (!inputFile.exists()) {
                return;
            }
            try {
                inputFile.delete();
            }
            catch (Exception e) {
                L.error("Cannot delete dirty data file", (Throwable)e);
            }
        }
    }
}

