/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change.persist;

import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.persist.ChangingPropObject;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangingPropReader {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ChangingPropReader.class);
    private IProject project;
    private Map<Integer, ChangingPropObject> persistedMap = new HashMap<Integer, ChangingPropObject>();
    private Map<Integer, Set<Integer>> children = new HashMap<Integer, Set<Integer>>();
    private Map<IResource, DirtyStatus> resultMap = new HashMap<IResource, DirtyStatus>();

    public ChangingPropReader(IProject project) {
        this.project = project;
    }

    public void read() {
        String inputName = ".dirty";
        File projectFile = this.project.getLocation().toFile();
        File inputFile = new File(projectFile, inputName);
        if (!inputFile.exists()) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                int parentID = in.readInt();
                int id = in.readInt();
                int type = in.readInt();
                String name = in.readUTF();
                ChangingPropObject o = new ChangingPropObject(parentID, id, DirtyStatus.toDirtyStatus(type), name);
                this.persistedMap.put(o.getId(), o);
                ++i;
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            L.debug("{} file not found for project {}", (Object)".dirty", (Object)this.project.getName());
        }
        catch (IOException iOException) {
            L.error("{} file has wrong data in project {}", (Object)".dirty", (Object)this.project.getName());
        }
        this.buildResources();
    }

    private void createChildren() {
        Set<Integer> ids = this.persistedMap.keySet();
        for (Integer id : ids) {
            ChangingPropObject o = this.persistedMap.get(id);
            Integer parentID = o.getParentID();
            Set<Integer> parentSet = this.children.get(parentID);
            if (parentSet == null) {
                parentSet = new HashSet<Integer>();
                this.children.put(parentID, parentSet);
            }
            parentSet.add(id);
        }
    }

    private void buildResources() {
        this.createChildren();
        IWorkspaceRoot root = this.project.getWorkspace().getRoot();
        try {
            this.goDeep(0, "", root);
        }
        catch (Exception e) {
            L.error("Error:", (Throwable)e);
        }
    }

    private void goDeep(int currentID, String parentPath, IWorkspaceRoot root) {
        ChangingPropObject o = this.persistedMap.get(currentID);
        String currentName = String.valueOf(parentPath) + "/" + o.getName();
        IResource resource = root.findMember(currentName);
        if (resource == null) {
            throw new RuntimeException("Resource cannot be null");
        }
        this.resultMap.put(resource, o.getType());
        Set<Integer> c = this.children.get(currentID);
        if (c != null) {
            for (Integer childID : c) {
                this.goDeep(childID, currentName, root);
            }
        }
    }

    public Map<IResource, DirtyStatus> getResultMap() {
        return this.resultMap;
    }

    public void clearCollections() {
        this.persistedMap.clear();
        this.children.clear();
    }
}

