/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change.persist;

import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.persist.ChangingPropObject;
import com.ez.workspace.change.persist.ChangingPropWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangingPropBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ChangingPropBuilder.class);
    public static final int NO_PARENT_ID = -1;
    private IProject project;
    private int currentID = 0;
    private Map<IResource, DirtyStatus> dirtyTypes;
    private Map<Integer, ChangingPropObject> map = new HashMap<Integer, ChangingPropObject>();
    private Map<IResource, Integer> resToID = new HashMap<IResource, Integer>();

    public ChangingPropBuilder(IProject project, Map<IResource, DirtyStatus> dirtyTypes) {
        this.project = project;
        this.dirtyTypes = dirtyTypes;
    }

    public Collection<ChangingPropObject> getResult() {
        Collection<ChangingPropObject> result = this.map.values();
        return result;
    }

    private ChangingPropObject createObject(IResource resource, int parentID, DirtyStatus type) {
        ChangingPropObject result = null;
        if (resource != null && type != null && type != DirtyStatus.DELETED_RESOURCE) {
            String name = resource.getName();
            result = new ChangingPropObject(parentID, this.currentID, type, name);
            this.map.put(this.currentID, result);
            this.resToID.put(resource, this.currentID);
            ++this.currentID;
        }
        return result;
    }

    public void buildFromMap() {
        if (this.project != null) {
            this.createObject((IResource)this.project, -1, DirtyStatus.NONE);
            Set<IResource> resources = this.dirtyTypes.keySet();
            for (IResource resource : resources) {
                Integer parentID;
                DirtyStatus type;
                Integer id = this.resToID.get(resource);
                if (id != null) {
                    type = this.dirtyTypes.get(resource);
                    if (type == DirtyStatus.DELETED_RESOURCE) continue;
                    parentID = this.getParentID(resource, type);
                    if (parentID != null) {
                        if (type != null) {
                            this.createObject(resource, parentID, type);
                            continue;
                        }
                        ChangingPropWriter.deleteDirtyDataFile(this.project);
                        this.resetAll();
                        L.error("There MUST have a dirty type");
                        continue;
                    }
                    ChangingPropWriter.deleteDirtyDataFile(this.project);
                    this.resetAll();
                    L.error("There MUST be a parent with ID");
                    continue;
                }
                type = this.dirtyTypes.get(resource);
                if (type == DirtyStatus.DELETED_RESOURCE) continue;
                parentID = this.getParentID(resource, type);
                if (parentID != null) {
                    if (type != null) {
                        this.createObject(resource, parentID, type);
                        continue;
                    }
                    ChangingPropWriter.deleteDirtyDataFile(this.project);
                    this.resetAll();
                    L.error("There MUST have a dirty type");
                    continue;
                }
                ChangingPropWriter.deleteDirtyDataFile(this.project);
                this.resetAll();
                L.error("There MUST be a parent with ID");
            }
        }
    }

    private void resetAll() {
        this.map.clear();
        this.currentID = 0;
        this.dirtyTypes.clear();
        this.resToID.clear();
    }

    private Integer getParentID(IResource resource, DirtyStatus type) {
        if (resource.getType() == 4) {
            return -1;
        }
        Integer result = null;
        if (resource == null) {
            result = null;
        } else {
            IContainer parent = resource.getParent();
            Integer parentID = this.resToID.get(parent);
            if (parentID != null) {
                result = parentID;
            } else {
                ChangingPropObject o;
                parentID = this.getParentID((IResource)parent, type);
                DirtyStatus parentType = this.dirtyTypes.get(parent);
                if (parentType == null) {
                    parentType = type;
                }
                if ((o = this.createObject((IResource)parent, parentID, parentType)) != null) {
                    result = o.getId();
                }
            }
        }
        return result;
    }

    public void buildFromDisk() {
        ChangingPropObject o;
        if (this.project != null && (o = this.createObject((IResource)this.project, -1, DirtyStatus.NONE)) != null) {
            try {
                IResource[] res = this.project.members();
                int i = 0;
                while (i < res.length) {
                    IResource resource = res[i];
                    this.goDeepDisk(resource, o.getId(), DirtyStatus.NONE);
                    ++i;
                }
            }
            catch (CoreException e) {
                L.error("Error:", (Throwable)e);
            }
        }
    }

    private void goDeepDisk(IResource resource, int parentID, DirtyStatus type) throws CoreException {
        IFolder folder;
        IResource[] list;
        ChangingPropObject o;
        if (resource != null && (o = this.createObject(resource, parentID, type)) != null && resource.getType() == 2 && (list = (folder = (IFolder)resource).members()).length > 0) {
            int i = 0;
            while (i < list.length) {
                IResource child = list[i];
                this.goDeepDisk(child, o.getId(), type);
                ++i;
            }
        }
    }
}

