/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change;

import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.persist.EZResourceManager;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourceChangeListener.class);
    private EZResourceManager resourceManager;
    private Queue<IResource> movedRenamedOld = new LinkedList<IResource>();
    private Queue<IResource> movedRenamedNew = new LinkedList<IResource>();

    public ResourceChangeListener(EZResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event != null) {
            switch (event.getType()) {
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    try {
                        event.getDelta().accept((IResourceDeltaVisitor)this);
                    }
                    catch (CoreException e) {
                        L.error("cannot visit resource", (Throwable)e);
                    }
                    break;
                }
                case 16: {
                    if (event.getBuildKind() != 0) break;
                    try {
                        event.getDelta().accept((IResourceDeltaVisitor)this);
                        break;
                    }
                    catch (CoreException e) {
                        L.error("cannot visit resource", (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource.getType() == 8) {
                return true;
            }
            if (resource.getType() == 4 && !resource.getProject().isOpen()) {
                return false;
            }
            if (this.isEzDerivedOrHiddenResource(resource)) {
                return true;
            }
            if (this.onlyEncodingHasChanged(delta)) {
                return true;
            }
            if (delta.getAffectedChildren().length > 0) {
                return true;
            }
            if (resource != null) {
                DirtyStatus status = DirtyStatus.RESOURCE_MODIFIED_REQUIRE_BUILD;
                if (this.hasMarkerFlag(delta)) {
                    status = DirtyStatus.MARKER_DIRTY_IGNORE;
                }
                this.resourceManager.buildChangingModel(resource, status);
                this.handleMovedOrRenamed(delta);
                this.handleDeleted(delta);
            }
        }
        return true;
    }

    private boolean hasMarkerFlag(IResourceDelta delta) {
        int flags;
        boolean result = false;
        if (delta != null && ((flags = delta.getFlags()) & 0x20000) != 0 && (flags & 0x100) == 0) {
            result = true;
        }
        return result;
    }

    private boolean onlyEncodingHasChanged(IResourceDelta delta) {
        boolean result = false;
        int flags = delta.getFlags();
        if ((flags & 0x100000) != 0) {
            result = true;
        }
        if ((flags & 4) != 0) {
            result = false;
        }
        return result;
    }

    private boolean isEzDerivedOrHiddenResource(IResource resource) {
        EZProject ezProject;
        boolean result = false;
        EZWorkspace wk = EZWorkspace.getInstance();
        if (resource != null && resource.getProject() != null && (ezProject = wk.getPrjModel((IResource)resource.getProject())) != null) {
            boolean bl = result = !ezProject.toBuild(resource);
            if (!result) {
                result = !ezProject.isVisibleResource(resource);
            }
        }
        return result;
    }

    private void handleMovedOrRenamed(IResourceDelta delta) {
        if (delta != null) {
            int flags = delta.getFlags();
            IResource resource = delta.getResource();
            if (!resource.getProject().isOpen()) {
                return;
            }
            if (delta.getKind() == 2 && (flags & 0x2000) != 0) {
                this.movedRenamedOld.add(resource);
            } else if (delta.getKind() == 1 && (flags & 0x1000) != 0) {
                this.movedRenamedNew.add(resource);
            } else if (delta.getKind() == 1) {
                this.resourceManager.addedNewResource(resource);
                return;
            }
            if (this.movedRenamedNew.size() != 0 && this.movedRenamedNew.size() == this.movedRenamedOld.size()) {
                IResource oldOne = this.movedRenamedOld.poll();
                IResource newOne = this.movedRenamedNew.poll();
                if (oldOne != null && newOne != null) {
                    this.resourceManager.moveOrRenameResource(oldOne, newOne);
                }
            }
        }
    }

    private void handleDeleted(IResourceDelta delta) {
        IResource res;
        if (delta != null && delta.getKind() == 2 && (res = delta.getResource()).getProject().isOpen()) {
            this.resourceManager.deletedResource(res);
        }
    }
}

