/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change;

import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.EZResourceModifiedEvent;
import com.ez.workspace.change.IEZResourceChangedListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZModifyResourceProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZModifyResourceProvider.class);
    List<IEZResourceChangedListener> listeners = new ArrayList<IEZResourceChangedListener>();
    NotifyThread notifyThread = null;

    public void addResourceModifiedListener(IEZResourceChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeResourceModifiedListener(IEZResourceChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void resourceModified(IResource resource, DirtyStatus type) {
        final EZResourceModifiedEvent e = new EZResourceModifiedEvent(this, type, resource);
        final Object[] listenersArray = this.listeners.toArray();
        if (this.notifyThread == null || this.notifyThread.stopped) {
            this.notifyThread = new NotifyThread();
            this.notifyThread.start();
        }
        this.notifyThread.executeRunnable(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < listenersArray.length) {
                    final IEZResourceChangedListener l = (IEZResourceChangedListener)listenersArray[i];
                    SafeRunnable runnable = new SafeRunnable(){

                        public void run() throws Exception {
                            l.resourceModified(e);
                        }

                        public void handleException(Throwable e2) {
                            L.error("Cannot dispatch events ", e2);
                        }
                    };
                    SafeRunnable.run((ISafeRunnable)runnable);
                    ++i;
                }
            }
        });
    }

    class NotifyThread
    extends Thread {
        public boolean stopped = false;
        private List<Runnable> toRun = Collections.synchronizedList(new ArrayList());
        final int timeout = 180000;

        public NotifyThread() {
            this.setName("EZModify-NotifyThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeRunnable(Runnable run) {
            this.toRun.add(run);
            NotifyThread notifyThread = this;
            synchronized (notifyThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ** GOTO lbl21
            {
                r = this.toRun.remove(0);
                r.run();
                do {
                    if (this.toRun.size() > 0) continue block5;
                    var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            while (this.toRun.size() == 0) {
                                this.wait(180000L);
                            }
                            if (this.toRun.size() == 0) {
                                this.stopped = true;
                            }
                        }
                        catch (InterruptedException e) {
                            EZModifyResourceProvider.access$0().error("Error:", (Throwable)e);
                        }
                    }
lbl21:
                    // 3 sources

                } while (!this.stopped);
            }
            EZModifyResourceProvider.this.notifyThread = null;
        }
    }
}

