/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.change;

import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.change.EZModifyResourceProvider;
import com.ez.workspace.change.IEZResourceChangedListener;
import com.ez.workspace.change.ResourceChangeListener;
import com.ez.workspace.change.persist.EZResourceManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;

public class EZChangingManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private EZModifyResourceProvider changingProvider;
    private ResourceChangeListener resourceChangeListener;
    private EZResourceManager resourceManager;
    private static EZChangingManager singleton;

    private void registerListeners() {
        this.resourceChangeListener = new ResourceChangeListener(this.resourceManager);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 23);
    }

    private void initializeChangingProvider() {
        if (this.changingProvider == null) {
            this.changingProvider = new EZModifyResourceProvider();
        }
    }

    public static EZChangingManager getManager() {
        if (singleton == null) {
            singleton = new EZChangingManager();
            singleton.init();
        }
        return singleton;
    }

    public void close() {
        if (this.resourceManager != null) {
            this.resourceManager.save();
        }
    }

    public void init() {
        this.initializeChangingProvider();
        this.resourceManager = new EZResourceManager(this.changingProvider);
        this.resourceManager.load();
        this.registerListeners();
    }

    public void registerEZResourceModifiedListener(IEZResourceChangedListener listener) {
        if (this.changingProvider == null) {
            this.changingProvider = new EZModifyResourceProvider();
        }
        this.changingProvider.addResourceModifiedListener(listener);
    }

    public void unregisterEZResourceModifiedListener(IEZResourceChangedListener listener) {
        if (this.changingProvider != null) {
            this.changingProvider.removeResourceModifiedListener(listener);
        }
    }

    private void handleCleanBuild(List<IResource> resources, DirtyStatus dirtyType) {
        if (this.resourceManager != null && resources != null) {
            HashSet<IProject> projects = new HashSet<IProject>();
            for (IResource resource : resources) {
                if (resource == null) continue;
                projects.add(resource.getProject());
                this.resourceManager.buildChangingModel(resource, dirtyType);
            }
            this.resourceManager.handleEmptyFolders4Projects(projects);
        }
    }

    public void notifyCleanedResources(List<IResource> resources) {
        this.handleCleanBuild(resources, DirtyStatus.CLEAN_OR_NO_MODEL);
    }

    public void notifyBuiltResources(List<IResource> resources) {
        this.handleCleanBuild(resources, DirtyStatus.BUILT_REQUIRE_REFRESH);
    }

    public Map<IResource, DirtyStatus> checkDirtyTypes4Resources(List<IResource> resources) {
        HashMap<IResource, DirtyStatus> result = new HashMap<IResource, DirtyStatus>();
        if (resources != null && !resources.isEmpty()) {
            for (IResource resource : resources) {
                DirtyStatus type;
                if (resource == null || (type = this.resourceManager.getDirtyType4Resource(resource)) == null) continue;
                result.put(resource, type);
            }
        }
        return result;
    }

    public DirtyStatus checkDirtyTypes4Resource(IResource resource) {
        DirtyStatus result = null;
        if (resource != null && resource != null && (result = this.resourceManager.getDirtyType4Resource(resource)) == DirtyStatus.BUILT_REQUIRE_REFRESH) {
            result = null;
        }
        return result;
    }
}

