/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.resources;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.analysis.resources.MultipleAnalysisJob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleAnalysis
extends AbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MultipleAnalysis.class);
    private Map<Integer, AbstractAnalysisJob> jobs = new HashMap<Integer, AbstractAnalysisJob>();
    private Set<Integer> canceledJobs = new HashSet<Integer>();

    @Override
    public void setInputs(List inputs) {
    }

    @Override
    protected AnalysisType getAnalysisType() {
        return null;
    }

    @Override
    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    @Override
    protected EZEntityID makeID() {
        return null;
    }

    @Override
    protected AbstractAnalysisJob getJob(Integer requestID) {
        MultipleAnalysisJob job = (MultipleAnalysisJob)this.jobs.get(requestID);
        if (job == null) {
            job = this.initJob();
            job.requestId = requestID;
            this.jobs.put(requestID, job);
        }
        return job;
    }

    protected abstract MultipleAnalysisJob initJob();

    @Override
    protected void setCanceled(Integer reqID, boolean canceled) {
        if (canceled) {
            this.canceledJobs.add(reqID);
        } else {
            this.canceledJobs.clear();
            super.setCanceled(reqID, canceled);
        }
    }

    @Override
    public boolean wasCancelled(Integer reqID) {
        if (reqID == null) {
            if (this.canceledJobs.contains(this.requestID)) {
                reqID = this.requestID;
            }
            L.info("verify canceled for a null id; cancel instead id={}", (Object)reqID);
        }
        boolean ret = this.canceledJobs.contains(reqID);
        return ret;
    }
}

