/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.job;

import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalysisJob
extends Job
implements GraphTranslateJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractAnalysisJob.class);
    Object waitObj;
    protected boolean endWait = false;
    protected boolean wasDenied = false;
    protected AbstractSharedAnalysis analysis;
    protected long jobStartTime;

    public AbstractAnalysisJob(String name, Object waitObj) {
        super(name);
        this.waitObj = waitObj;
        this.setUser(true);
    }

    public AbstractAnalysisJob(String name) {
        this(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beginJob(IProgressMonitor pmonitor) {
        boolean wasCancelled = false;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)10);
        if (this.waitObj != null) {
            boolean wait = !this.endWait;
            monitor.setTaskName(Messages.getString(AbstractAnalysisJob.class, "taskName"));
            int waitTime = 2000;
            block5: while (true) {
                try {
                    while (wait) {
                        if (monitor.isCanceled()) {
                            L.debug("!!!!!!!!!! monitor cancelled ");
                            this.analysis.cancellRequest(null);
                            wait = false;
                            wasCancelled = true;
                            continue;
                        }
                        Object object = this.waitObj;
                        synchronized (object) {
                            this.waitObj.wait(waitTime);
                            if (this.endWait) {
                                L.info("server callback");
                                wait = false;
                            }
                            continue block5;
                        }
                    }
                    break;
                }
                catch (InterruptedException e1) {
                    L.error("beginJob()", (Throwable)e1);
                    break;
                }
            }
        }
        monitor.worked(10);
        if (this.wasDenied) {
            wasCancelled = true;
        }
        L.debug("end job waiting; wasCancelled = {}", (Object)wasCancelled);
        return !wasCancelled;
    }

    public void setWaitObj(Object waitObj) {
        this.waitObj = waitObj;
    }

    public Object getWaitObj() {
        return this.waitObj;
    }

    public void endWait() {
        this.endWait = true;
    }

    public void setDenied(boolean isDenied) {
        this.wasDenied = isDenied;
    }

    protected void canceling() {
        L.debug("job cancelling");
        if (this.analysis != null) {
            this.analysis.cancellRequest(null);
        }
        super.canceling();
    }

    public void setAnalysis(AbstractSharedAnalysis analysis) {
        this.analysis = analysis;
    }

    public AbstractSharedAnalysis getAnalysis() {
        return this.analysis;
    }

    public void clearJob() {
        this.endWait = false;
        this.wasDenied = false;
        this.waitObj = null;
    }
}

