/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph;

import com.ez.workspace.internal.Messages;
import java.util.List;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExecExportStatus
implements Runnable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public boolean exportStatus = false;
    public boolean openFileOnExportOk = true;
    public String title = null;
    public String exportFile = null;
    public List<String> exportFileList = null;
    private static final int MIN_TITLE = 100;
    private static final String EXPORT_MSGBOX_TITLE = Messages.getString(ExecExportStatus.class, "exportGraph.exportMsgBox.title");
    private static final String EXPORT_MSGBOX_FAILED = Messages.getString(ExecExportStatus.class, "exportGraph.exportFailed.message");
    private static final String EXPORT_MSGBOX_COMPLETED = Messages.getString(ExecExportStatus.class, "exportGraph.exportCompleted.message");

    public ExecExportStatus() {
        StringBuffer sb = new StringBuffer();
        sb.append(EXPORT_MSGBOX_TITLE);
        while (sb.length() < 100) {
            sb.append(" ");
        }
        this.title = sb.toString();
    }

    @Override
    public void run() {
        Shell shell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
        MessageBox box = null;
        StringBuffer msg = new StringBuffer();
        if (this.exportStatus) {
            if (this.openFileOnExportOk) {
                box = new MessageBox(shell, 194);
                msg.append(EXPORT_MSGBOX_COMPLETED);
            } else {
                box = new MessageBox(shell);
                msg.append(Messages.getString(ExecExportStatus.class, "exportFinished.message"));
            }
        } else {
            box = new MessageBox(shell, 66);
            msg.append(EXPORT_MSGBOX_FAILED);
        }
        if (box != null) {
            box.setMessage(msg.toString());
            box.setText(this.title);
            int ret = box.open();
            if (ret == 64) {
                if (this.exportFile != null) {
                    Program.launch((String)this.exportFile);
                } else {
                    for (String file : this.exportFileList) {
                        Program.launch((String)file);
                    }
                }
            }
        }
    }
}

