/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis;

import com.ez.internal.analysis.config.context.IgnoreContext;
import com.ez.internal.analysis.config.inputs.AnalysisInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.analysis.filters.EZInputParamFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZAnalysisType {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZAnalysisType.class);
    public static final int UNKNOWN_SCOPE = -1;
    public static final int WORKSPACE_SCOPE = 0;
    public static final int ENCLOSING_SCOPE = 1;
    public static final int WORKINGSET_SCOPE = 2;
    private String id = null;
    private String name = null;
    private Class clazz = null;
    private ImageDescriptor iconDescriptor = null;
    private Set inputs = new HashSet();
    private Class inputFilterClazz = null;
    private String variant = null;
    private String bundle = null;
    private String category = "com.ez.workspace.category.other";
    private EZInputFilter inputFilter = null;
    private Properties filterParams = null;
    private boolean hasSettings = false;
    private String viewId = null;

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addInputType(AnalysisInputType analysisInputType) {
        this.inputs.add(analysisInputType);
    }

    public ImageDescriptor getIconDescriptor() {
        return this.iconDescriptor;
    }

    public void setIconDescriptor(ImageDescriptor iconDescriptor) {
        this.iconDescriptor = iconDescriptor;
    }

    public String toString() {
        return this.name;
    }

    public void setInputFilterClazz(Class inputFilterClazz) {
        this.inputFilterClazz = inputFilterClazz;
    }

    public Iterator<AnalysisInputType> getInputsIterator() {
        return this.inputs.iterator();
    }

    public EZAnalysis getImplementorInstance() {
        EZAnalysis analysis = null;
        if (this.clazz != null) {
            try {
                analysis = (EZAnalysis)this.clazz.newInstance();
                analysis.setType(this);
            }
            catch (IllegalAccessException ex) {
                L.error("getImplementorInstance()", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                L.error("getImplementorInstance()", (Throwable)ex);
            }
            catch (Throwable e) {
                L.error("", e);
            }
        }
        return analysis;
    }

    public EZInputFilter getInputFilterInstance() {
        if (this.inputFilter == null && this.inputFilterClazz != null) {
            try {
                this.inputFilter = (EZInputFilter)this.inputFilterClazz.newInstance();
                if (this.filterParams != null) {
                    ((EZInputParamFilter)this.inputFilter).setParameters(this.filterParams);
                }
            }
            catch (IllegalAccessException ex) {
                L.error("getInputFilterInstance() {}", (Object)this.inputFilterClazz, (Object)ex);
            }
            catch (InstantiationException ex) {
                L.error("getInputFilterInstance() {}", (Object)this.inputFilterClazz, (Object)ex);
            }
        }
        return this.inputFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EZAnalysisType)) {
            return false;
        }
        EZAnalysisType type = (EZAnalysisType)obj;
        return this.id.equals(type.id) && this.clazz.equals(type.clazz) && this.name.equals(type.name);
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setCategory(String category) {
        if (category != null && !category.trim().isEmpty()) {
            this.category = category;
        }
    }

    public String getCategory() {
        return this.category;
    }

    public boolean acceptsInputTypes(Collection oInpTypes) {
        boolean has = false;
        if (oInpTypes != null && oInpTypes.size() > 0) {
            has = true;
            for (Object o : oInpTypes) {
                if (o instanceof EZObjectType) {
                    boolean localHas = false;
                    for (Object obj : this.inputs) {
                        AnalysisInputType ait = (AnalysisInputType)obj;
                        if (!ait.getInput().getCanonicalName().equals(o.getClass().getCanonicalName()) || ait.getContext() != IgnoreContext.class && ait.getContext() != ((EZObjectType)o).getContext()) continue;
                        localHas = true;
                        break;
                    }
                    if (localHas) continue;
                    has = false;
                    continue;
                }
                has = false;
                break;
            }
        }
        return has;
    }

    public void setParameters(Properties parameters) {
        this.filterParams = parameters;
    }

    public Properties getFilterParams() {
        return this.filterParams;
    }

    public boolean hasSettings() {
        return this.hasSettings;
    }

    public void setHasSettings(boolean hasSettings) {
        this.hasSettings = hasSettings;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }
}

